% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_interactions.R
\name{search_interactions}
\alias{search_interactions}
\title{Query interactions}
\usage{
search_interactions(query, type = NULL, expand_node = FALSE, ...)
}
\arguments{
\item{query}{either a character string including a single keyword or a named
list containing a custom query (see details section below). Note that if an
empty character string is passed, then all available entries are returned.}

\item{type}{a \code{character} one of the interactions type available (see
details). Note that \code{query} is ignored if \code{type} is used.}

\item{expand_node}{a logical. Should the function returned extra information
pertaining to nodes? Default is set to \code{FALSE}, which means that only the
Mangal IDs of nodes are returned.}

\item{...}{Additional arguments passed to \code{\link[=rmangal_request]{rmangal_request()}}, including the
argument \code{cache} that allows requests caching.}
}
\value{
An object of class \code{mgSearchInteractions}, i.e. a \code{data.frame} object
including interactions.
All networks in which interactions are involved are also attached to the
\code{data.frame}.
}
\description{
Search for specific interactions using a keyword or a specific type of
interactions (e.g. mutualism). If the \code{query} is a character string, then
all character columns in the table are searched and the entries for which at
least one partial match was found are returned.
Alternatively, a named list can be used to look for an exact match in a
specific column (see Details).
}
\details{
Names of the list should match one of the column names within the table.
For the \code{interaction} table, those are:
\itemize{
\item \code{id}: unique identifier of the interaction;
\item \code{attr_id}: identifier of a specific attribute;
\item \code{direction}: edge direction ("directed", "undirected" or "unknown");
\item \code{network_id}: Mangal network identifier;
\item \code{node_from}: node id which the interaction originates;
\item \code{node_to}: node to which the interaction goes;
\item \code{type}: use argument \code{type} instead.
}

Note that for lists with more than one element, only the first element is
used, the others are ignored. The type of interactions (argument \code{type})
currently available are the following
\itemize{
\item "competition";
\item "amensalism";
\item "neutralism";
\item "commensalism";
\item "mutualism";
\item "parasitism";
\item "predation";
\item "herbivory";
\item "symbiosis";
\item "scavenger";
\item "detritivore".
}
}
\examples{
\donttest{
df_inter <- search_interactions(type = "competition")
# Get all networks containing competition
competition_networks <- get_collection(df_inter)
df_net_926 <- search_interactions(list(network_id = 926))
}
}
\references{
\itemize{
\item \url{https://mangal.io/#/}
\item \url{https://mangal-interactions.github.io/mangal-api/#taxonomy}
}
}
