% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_statis_phase2.R
\name{robust_statis_phase2}
\alias{robust_statis_phase2}
\title{Robust STATIS Dual - Phase 2 (New Batches Evaluation)}
\usage{
robust_statis_phase2(
  new_data,
  variables,
  medians,
  mads,
  compromise_matrix,
  global_center
)
}
\arguments{
\item{new_data}{A data frame containing the new batches to evaluate.}

\item{variables}{Character vector with the names of the variables to be used.}

\item{medians}{Named numeric vector containing the global medians obtained in Phase 1.}

\item{mads}{Named numeric vector containing the scaled MADs obtained in Phase 1.}

\item{compromise_matrix}{Robust compromise matrix computed in Phase 1.}

\item{global_center}{Robust global center obtained in Phase 1.}
}
\value{
A list containing:
\describe{
\item{standardized_data}{Data frame with the new batches standardized using the global medians and scaled MADs.}
\item{t2_stats_by_batch}{Data frame with the Hotelling-type \( T^2 \) statistics per batch.}
\item{threshold}{Control limit based on the Chi-squared distribution (0.9973 quantile, degrees of freedom equal to the number of variables).}
}
}
\description{
Applies the robust STATIS Dual control chart methodology to evaluate new batches,
using the compromise matrix and the global robust center obtained in Phase 1.
Each batch is summarized using a robust Hotelling-type \( T^2 \) statistic.
}
\examples{
# Simulate new pharmaceutical manufacturing batches
sim_batches <- simulate_pharma_batches()

# Phase 1 analysis: use only Phase 1 and under control batches
phase1_data <- subset(sim_batches, Phase == "Phase 1" & Status == "Under Control")
phase1 <- robust_statis_phase1(
  data = phase1_data,
  variables = c("Concentration", "Humidity", "Dissolution", "Density")
)

# Phase 2 analysis: evaluate new batches (Phase 2)
new_data <- subset(sim_batches, Phase == "Phase 2")
result_phase2 <- robust_statis_phase2(
  new_data = new_data,
  variables = c("Concentration", "Humidity", "Dissolution", "Density"),
  medians = phase1$global_medians,
  mads = phase1$global_mads,
  compromise_matrix = phase1$compromise_matrix,
  global_center = phase1$global_center
)

# View main outputs
result_phase2$t2_stats_by_batch
result_phase2$threshold
}
\keyword{internal}
