% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLongitudinalBySubject.R
\name{plotLongitudinalBySubject}
\alias{plotLongitudinalBySubject}
\title{Plot longitudinal data with robustness-weight colored lines}
\usage{
plotLongitudinalBySubject(
  data,
  formula = NULL,
  idVar = "id",
  timeVar = "time",
  treatmentVar = "treatment",
  responseVar = "y",
  rlmerArgs = list(),
  lineAlpha = 0.6,
  fixedLineWidth = 1.2,
  lowColor = "black",
  highColor = "lightgray",
  fixedLineColor = "firebrick",
  fixedLinetype = "solid",
  title = NULL,
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{data}{A data frame containing longitudinal data. Must have columns
for subject ID, time, treatment group, and response variable.}

\item{formula}{A formula for the mixed-effects model. Default is
\code{y ~ treatment * time + (1 + time | id)} where \code{y},
\code{treatment}, \code{time}, and \code{id} refer to the standardized
internal column names (mapped from \code{responseVar}, \code{treatmentVar},
\code{timeVar}, and \code{idVar}).}

\item{idVar}{Character string naming the subject ID column in \code{data}.
Default: \code{"id"}.}

\item{timeVar}{Character string naming the time column in \code{data}.
Default: \code{"time"}.}

\item{treatmentVar}{Character string naming the treatment column in
\code{data}. Default: \code{"treatment"}.}

\item{responseVar}{Character string naming the response column in
\code{data}. Default: \code{"y"}.}

\item{rlmerArgs}{A list of additional arguments passed to
\code{\link{rlmer}}.}

\item{lineAlpha}{Numeric in [0, 1]. Transparency of subject lines.
Default: 0.6.}

\item{fixedLineWidth}{Numeric. Width of fixed-effect overlay lines.
Default: 1.2.}

\item{lowColor}{Color for low robustness weights (potential outliers).
Default: \code{"black"}.}

\item{highColor}{Color for high robustness weights (typical observations).
Default: \code{"lightgray"}.}

\item{fixedLineColor}{Color for the fixed-effect prediction lines.
Default: \code{"firebrick"}.}

\item{fixedLinetype}{Linetype for the fixed-effect prediction lines. Can be
a single value (e.g., \code{"solid"}, \code{"dashed"}) applied to all
lines, or \code{"byTreatment"} to use different linetypes for each
treatment group. Default: \code{"solid"}.}

\item{title}{Optional plot title.}

\item{xlab}{Label for x-axis. If \code{NULL} (default), uses the value of
\code{timeVar}.}

\item{ylab}{Label for y-axis. If \code{NULL} (default), uses the value of
\code{responseVar}.}
}
\value{
A \code{ggplot} object.
}
\description{
Creates a visualization of longitudinal data with one facet per treatment
group. Subject trajectories are colored by their robustness weight from a
robust mixed-effects model fit, with darker lines indicating lower weights
(potential outliers). Fixed-effect predictions are overlaid as reference
lines.
}
\details{
The function fits a robust linear mixed-effects model using
\code{\link{rlmer}} and extracts the robustness weights for the random
effects. Subjects with low weights (shown in darker colors) are those whose
random effects deviate substantially from the assumed distribution.

The fixed-effect prediction lines show the population-average trajectory
for each treatment group, ignoring random effects.
}
\examples{
\dontrun{
  ## Using the medication dataset from confintROB
  library(confintROB)
  plotLongitudinalBySubject(
    medication,
    idVar = "id",
    treatmentVar = "treat",
    responseVar = "pos"
  )

  ## Using simulated data
  set.seed(123)
  simdat <- generateLongitudinalDatasets(
    numberOfDatasetsToGenerate = 1,
    numberOfSubjects = 40,
    numberOfTimepoints = 7,
    numberOfTreatmentLevels = 2,
    timeRange = c(0, 18),
    trueBeta = c(200, -2, -5, 3),
    trueSigma = 30
  )
  plotLongitudinalBySubject(simdat$generateData(1))
}

}
\seealso{
\code{\link{rlmer}}, \code{\link{generateLongitudinalDatasets}}
}
