% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.summary.kroclearn.R
\name{summary.cv.kroclearn}
\alias{summary.cv.kroclearn}
\title{Summarize Cross-Validation results for kernel models}
\usage{
\method{summary}{cv.kroclearn}(object, ...)
}
\arguments{
\item{object}{A fitted cross-validation object of class
\code{"cv.kroclearn"} (kernel).}

\item{...}{Not used.}
}
\value{
Invisibly returns the input \code{object}, after printing a summary
to the console.
}
\description{
Print a concise summary of cross-validation results for a kernel model.
}
\details{
This is a method for the generic \code{summary()} function, applied to
objects of class \code{"cv.kroclearn"}. It prints training settings
(loss, kernel type, number of folds, the set of candidate \eqn{\lambda}),
the selected optimal \eqn{\lambda}, the corresponding mean and standard
deviation of cross-validated AUC, and a truncated table of AUC results
across candidate \eqn{\lambda} values.
}
\examples{
set.seed(123)

n <- 100
r <- sqrt(runif(n, 0.05, 1))
theta <- runif(n, 0, 2*pi)
X <- cbind(r * cos(theta), r * sin(theta))
y <- ifelse(r < 0.5, 1, -1)

cvfit <- cv.kroclearn(
  X, y,
  lambda.vec = exp(seq(log(0.01), log(5), length.out = 3)),
  kernel = "radial",
  approx=TRUE, nfolds = 2
)

summary(cvfit)
}
