% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity.R
\name{remove_entity}
\alias{remove_entity}
\title{Remove entity}
\usage{
remove_entity(rocrate, entity)
}
\arguments{
\item{rocrate}{RO-Crate object, see \link{rocrate}.}

\item{entity}{Entity object (list) that contains at least the following
components: \verb{@id} and \verb{@type}. Or, scalar value with entity \verb{@id}.}
}
\value{
Updated RO-Crate object.
}
\description{
Remove entity
}
\examples{
basic_crate <- rocrateR::rocrate()

# create entity for an organisation
organisation_uol <- rocrateR::entity(
  x = "https://ror.org/04xs57h96",
  type = "Organization",
  name = "University of Liverpool",
  url = "http://www.liv.ac.uk"
)

# create an entity for a person
person_rvd <- rocrateR::entity(
  x = "https://orcid.org/0000-0001-5036-8661",
  type = "Person",
  name = "Roberto Villegas-Diaz",
  affiliation = list(`@id` = organisation_uol$`@id`)
)

basic_crate_v2 <- basic_crate |>
  rocrateR::add_entity(person_rvd) |>
  rocrateR::add_entity_value(id = "./", key = "author", value = list(`@id` = person_rvd$`@id`)) |>
  rocrateR::add_entity(organisation_uol) |>
  rocrateR::remove_entity(person_rvd)
}
