% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-json.R
\name{write_rocrate}
\alias{write_rocrate}
\title{Wrapper for \link[jsonlite:read_json]{jsonlite::write_json}}
\usage{
write_rocrate(x, path, ...)
}
\arguments{
\item{x}{RO-Crate object, see \link{rocrate}.}

\item{path}{file on disk}

\item{...}{
  Arguments passed on to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON}}
  \describe{
    \item{\code{dataframe}}{how to encode data.frame objects: must be one of 'rows', 'columns' or 'values'}
    \item{\code{matrix}}{how to encode matrices and higher dimensional arrays: must be one of 'rowmajor' or 'columnmajor'.}
    \item{\code{Date}}{how to encode Date objects: must be one of 'ISO8601' or 'epoch'}
    \item{\code{POSIXt}}{how to encode POSIXt (datetime) objects: must be one of 'string', 'ISO8601', 'epoch' or 'mongo'}
    \item{\code{factor}}{how to encode factor objects: must be one of 'string' or 'integer'}
    \item{\code{complex}}{how to encode complex numbers: must be one of 'string' or 'list'}
    \item{\code{raw}}{how to encode raw objects: must be one of 'base64', 'hex' or 'mongo'}
    \item{\code{null}}{how to encode NULL values within a list: must be one of 'null' or 'list'}
    \item{\code{na}}{how to print NA values: must be one of 'null' or 'string'. Defaults are class specific}
    \item{\code{digits}}{max number of decimal digits to print for numeric values. Use \code{\link[=I]{I()}} to specify significant digits. Use \code{NA} for max precision.}
    \item{\code{force}}{unclass/skip objects of classes with no defined JSON mapping}
  }}
}
\value{
Invisibly the input RO-Crate, \code{x}.
}
\description{
Wrapper for \link[jsonlite:read_json]{jsonlite::write_json}. Enforces that the input object is an
RO-Crate.
}
