% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{rdf_add}
\alias{rdf_add}
\title{Add a Triple}
\usage{
rdf_add(store, subject, predicate, object, graph = NULL)
}
\arguments{
\item{store}{An RDF store handle}

\item{subject}{Subject IRI (e.g., \code{"<http://example.org/s>"}) or blank node ("_:b1")}

\item{predicate}{Predicate IRI (e.g., \code{"<http://example.org/p>"})}

\item{object}{Object: IRI, blank node, or literal (e.g., '"value"')}

\item{graph}{Optional named graph IRI}
}
\value{
Invisibly returns NULL
}
\description{
Adds a single triple to the store.
}
\examples{
store <- rdf_store()
rdf_add(store, "<http://example.org/s>", "<http://example.org/p>", '"hello"')
rdf_size(store)
}
