% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgdbconn.R
\name{pgdbconn}
\alias{pgdbconn}
\alias{dbc}
\alias{dbd}
\alias{init_yamls}
\alias{dir_rpg}
\alias{edit_config}
\alias{edit_options}
\title{Database Connect/Disconnect}
\usage{
dbc(cfg = NULL, db = NULL, args_only = FALSE, cfg_path = NULL, opt_path = NULL)

dbd(cn)

init_yamls()

dir_rpg()

edit_config()

edit_options()
}
\arguments{
\item{cfg}{a connection config name used when loading connection args from internally stored yaml}

\item{db}{Database name. Default of NULL will utilize the dbname in the connection string}

\item{args_only}{If TRUE, only return the connection arguments (Default FALSE will make the connection)}

\item{cfg_path}{optional path to override default db config file.}

\item{opt_path}{optional path to override default db options file.}

\item{cn}{a database connection object}
}
\value{
\code{dbc} returns a database connection object or a list of connection arguments while \code{dbd} returns nothing
}
\description{
Database Connect/Disconnect
}
\section{Functions}{
\itemize{
\item \code{dbc()}: Connect to a database or return the connection arguments

\item \code{dbd()}: Disconnect from a database

\item \code{init_yamls()}: Initialize connection files

\item \code{dir_rpg()}: get the path to the rpg settings directory

\item \code{edit_config()}: edit the internally configured connection parameters

\item \code{edit_options()}: edit the internally configured connection options

}}
\examples{
# cn <- dbc("mydb") # Connect
# dbd(cn)           # Disconnect
}
