% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_pos_and_access.R
\name{cell_values}
\alias{cell_values}
\alias{value_at}
\alias{value_at,VTableTree-method}
\title{Retrieve cell values by row and column path}
\usage{
cell_values(tt, rowpath = NULL, colpath = NULL, omit_labrows = TRUE)

value_at(tt, rowpath = NULL, colpath = NULL)

\S4method{value_at}{VTableTree}(tt, rowpath = NULL, colpath = NULL)
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{rowpath}{(\code{character})\cr path in row-split space to the desired row(s). Can include \code{"@content"}.}

\item{colpath}{(\code{character})\cr path in column-split space to the desired column(s). Can include \code{"*"}.}

\item{omit_labrows}{(\code{flag})\cr whether label rows underneath \code{rowpath} should be omitted (\code{TRUE}, the default),
or return empty lists of cell "values" (\code{FALSE}).}
}
\value{
\itemize{
\item \code{cell_values} returns a \code{list} (regardless of the type of value the cells hold). If \code{rowpath} defines a path to
a single row, \code{cell_values} returns the list of cell values for that row, otherwise a list of such lists, one for
each row captured underneath \code{rowpath}. This occurs after subsetting to \code{colpath} has occurred.
\item \code{value_at} returns the "unwrapped" value of a single cell, or an error, if the combination of \code{rowpath} and
\code{colpath} do not define the location of a single cell in \code{tt}.
}
}
\description{
Retrieve cell values by row and column path
}
\note{
\code{cell_values} will return a single cell's value wrapped in a list. Use \code{value_at} to receive the "bare" cell
value.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by("SEX") \%>\%
  split_rows_by("RACE") \%>\%
  summarize_row_groups() \%>\%
  split_rows_by("STRATA1") \%>\%
  analyze("AGE")

\dontshow{if (require(dplyr)) withAutoprint(\{ # examplesIf}
library(dplyr) ## for mutate
tbl <- build_table(lyt, DM \%>\%
  mutate(SEX = droplevels(SEX), RACE = droplevels(RACE)))

row_paths_summary(tbl)
col_paths_summary(tbl)

cell_values(
  tbl, c("RACE", "ASIAN", "STRATA1", "B"),
  c("ARM", "A: Drug X", "SEX", "F")
)

# it's also possible to access multiple values by being less specific
cell_values(
  tbl, c("RACE", "ASIAN", "STRATA1"),
  c("ARM", "A: Drug X", "SEX", "F")
)
cell_values(tbl, c("RACE", "ASIAN"), c("ARM", "A: Drug X", "SEX", "M"))

## any arm, male columns from the ASIAN content (i.e. summary) row
cell_values(
  tbl, c("RACE", "ASIAN", "@content"),
  c("ARM", "B: Placebo", "SEX", "M")
)
cell_values(
  tbl, c("RACE", "ASIAN", "@content"),
  c("ARM", "*", "SEX", "M")
)

## all columns
cell_values(tbl, c("RACE", "ASIAN", "STRATA1", "B"))

## all columns for the Combination arm
cell_values(
  tbl, c("RACE", "ASIAN", "STRATA1", "B"),
  c("ARM", "C: Combination")
)

cvlist <- cell_values(
  tbl, c("RACE", "ASIAN", "STRATA1", "B", "AGE", "Mean"),
  c("ARM", "B: Placebo", "SEX", "M")
)
cvnolist <- value_at(
  tbl, c("RACE", "ASIAN", "STRATA1", "B", "AGE", "Mean"),
  c("ARM", "B: Placebo", "SEX", "M")
)
stopifnot(identical(cvlist[[1]], cvnolist))
\dontshow{\}) # examplesIf}
}
