% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffFullScan.R
\name{getFullScanAreas}
\alias{getFullScanAreas}
\title{Get the total area for given masses for a particular well}
\usage{
getFullScanAreas(scanfile, tic, sample, ejections, peaks, well)
}
\arguments{
\item{scanfile}{A file path to a Sciex raw scan file (extension .wiff.scan)
containing the raw data referenced by the .wiff file from which the other
parameters were extracted}

\item{tic}{A total ion chromatogram of the format outputby \code{\link[=getTIC]{getTIC()}} or
\code{\link[=getAllTIC]{getAllTIC()}}}

\item{sample}{The particular object from the \code{samples} field of the
\code{rtmsWiffReader} object, which in this case contains binary offsets into the
.wiff.scan file}

\item{ejections}{An ejection table listing the timing and boundaries of the
total ion chromatogram peaks for all shots in the run, as returned by
\code{\link[=measureEjections]{measureEjections()}}}

\item{peaks}{A named list of peak objects of class \code{rtmsPeak}}

\item{well}{The well (a string) or well index (an integer) to be measured}
}
\value{
A data frame containing the total intensity for \code{rtmsPeak} gvien
and each ejection; see Details for column specifics.
}
\description{
Get the total area for given masses for a particular well
}
\details{
The table return includes a measurement of total area for each of the mass
transitions listed in \code{sample}.  It contains one row for each measured shot
each mass transition, with the following columns:
\itemize{
\item \code{shotorder}: The order of the peak within the shots fired during the run
\item \code{well}: The alphanumeric well name of the well from which the shot was
fired
\item \code{time}: The time (in seconds) after the beginning of the run at which the
intensity from the shot was at its peak
\item \code{massindex}: The index of the measured mass transition in the set of masses
in the given sample
\item \code{mass}: The name of the mass transition measured (often a compound name or
id)
\item \code{area}: The intensity area (in counts) for that particular mass transition
from that ejection
}
}
