% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffFullScan.R
\name{processAllFullScanAreas}
\alias{processAllFullScanAreas}
\title{Fully process a Full Scan Wiff and scan File}
\usage{
processAllFullScanAreas(wiffFile, wiffScanFile, peaks, ...)
}
\arguments{
\item{wiffFile}{A valid file path to the Sciex data file (extension .wiff)
containing the metadata for one or more EchoMS runs}

\item{wiffScanFile}{An file path the the Sciex scan file (extension
.wiff.scan) containing the full raw EchoMS data}

\item{peaks}{A named list of peak objects of class \code{rtmsPeak}, often
generated by \code{rtmsPeakList()}}

\item{...}{Additional arguments passed to \code{measureEjections()}}
}
\value{
A list with two objects: \code{ejections}, a data frame listing all
ejections for all samples in the WIFF file, with an additional \code{wiffSample}
column specifying which sample each ejection was extracted from; and
\code{massAreas}, a data frame of the format returned by \code{\link[=getAllFullScanAreas]{getAllFullScanAreas()}},
also with an additional \code{wiffSample} column
}
\description{
A convenient wrapper function to extract all full scan areas from a file
without storing the intermediate reader and ejection data structures.
}
