% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxsolve.R
\name{odeMethodToInt}
\alias{odeMethodToInt}
\title{Conversion between character and integer ODE integration methods for rxode2}
\usage{
odeMethodToInt(method = c("liblsoda", "lsoda", "dop853", "indLin"))
}
\arguments{
\item{method}{The method for solving ODEs.  Currently this supports:
\itemize{
\item \code{"liblsoda"} thread safe lsoda.  This supports parallel
thread-based solving, and ignores user Jacobian specification.
\item \code{"lsoda"} -- LSODA solver.  Does not support parallel thread-based
solving, but allows user Jacobian specification.
\item \code{"dop853"} -- DOP853 solver.  Does not support parallel thread-based
solving nor user Jacobian specification
\item \code{"indLin"} -- Solving through inductive linearization.  The rxode2 dll
must be setup specially to use this solving routine.
}}
}
\value{
An integer for the method (unless the input is NULL, in which case,
see the details)
}
\description{
If \code{NULL} is given as the method, all choices are returned as a named
vector.
}
\keyword{Internal}
