% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{air_pollution}
\alias{air_pollution}
\title{Air pollution data}
\format{
A data frame with 50 observations on the following 15 variables.
\describe{
\item{CITY}{a factor with levels \code{AUGUSTA}
\code{AUSTIN} \code{BEAUMONT} \code{BOSTON} \code{BRIDGEPO} \code{CHARLEST}
\code{CHARLOTT} \code{CHATTANO} \code{CHICAGO} \code{CLEVELAN}
\code{COLUMBUS} \code{DALLAS} \code{DAYTON} \code{DENVER} \code{DES_MOIN}
\code{DETROIT} \code{EL_PASO} \code{FALL_RIV} \code{FLINT} \code{FORT_WOR}
\code{FRESNO} \code{GALVESTO} \code{HUNTINGT} \code{INDIANAP} \code{JACKSON}
\code{JERSEY_C} \code{JOHNSTOW} \code{KNOXVILL} \code{MACON} \code{MEMPHIS}
\code{MIAMI} \code{MILWAUKE} \code{MOBILE} \code{NASHVIL} \code{NORFOLK}
\code{OMAHA} \code{PHOENIX} \code{PROVIDEN} \code{READING} \code{ROCKFORD}
\code{SAVANNAH} \code{SEATTLE} \code{SIOUX_FA} \code{SOUTH_BE} \code{TOLEDO}
\code{TOPEKA} \code{WINSTON} \code{YORK} \code{YOUNGSTO}. Ville où les données ont été observées.}
\item{TMR}{a numeric vector. Taux de mortalité exprimé en 1/10000.}
\item{SMIN}{a numeric vector. Plus petite valeur des relevés réalisés deux fois par semaine de sulfate (micro-g/m3 multiplié par 10).}
\item{SMEAN}{a numeric vector. Moyenne arithmétique des relevés réalisés deux fois par semaine de sulfate (micro-g/m3 multiplié par 10).}
\item{SMAX}{a numeric vector. Plus grande valeur des relevés réalisés deux fois par semaine de sulfate (micro-g/m3 multiplié par 10).}
\item{PMIN}{a numeric vector. Plus petite valeur des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
\item{PMEAN}{a numeric vector. Moyenne arithmétique des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
\item{PMAX}{a numeric vector. Logarithme de la plus grande valeur des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
\item{PM2}{a numeric vector. Densité de la population par mile carré (multiplié par 0,1).}
\item{PERWH}{a numeric vector. Pourcentage de population blanche.}
\item{NONPOOR}{a numeric vector. Pourcentage de ménages avec un revenu au dessus du seuil de pauvreté.}
\item{GE65}{a numeric vector.  Pourcentage (multiplié par 10) de la population des 65 ans et plus.}
\item{LPOP}{a numeric vector. Logarithme (en base 10 et multiplié par 10) de la population.}
\item{l_pm2}{a numeric vector. Logarithme de la densité de la population par mile carré (multiplié par 0,1).}
\item{l_pmax}{a numeric vector. Logarithme de la plus grande valeur des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
}
}
\usage{
air_pollution
}
\description{
Échantillon de 50 villes (individus) tirées aléatoirement sur la pollution de l'air aux États-Unis en 1960
}
\examples{

data(air_pollution)
str(air_pollution)
library(ggplot2)
library(GGally)
GGally::ggpairs(air_pollution[,2:4],)

}
\keyword{datasets}
