% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sameplot.R
\name{sameplot}
\alias{sameplot}
\title{Render a plot consistently across RStudio, saved files, and knitr output}
\usage{
sameplot(
  plot,
  file = NULL,
  width = 6.4,
  height = 4.8,
  units = "in",
  background = "white",
  scaling = 1,
  bitsize = 8,
  res = 300,
  save = FALSE
)
}
\arguments{
\item{plot}{A plot object. Typically a ggplot, but any object whose \code{print()}
method draws to the active graphics device.}

\item{file}{Output filename (relative or absolute). Must include an extension
\code{.png} or \code{.tif}/\code{.tiff}. Required when \code{save = TRUE}.}

\item{width, height}{Plot size.}

\item{units}{Units for \code{width} and \code{height} (e.g., \code{"in"}, \code{"cm"}, \code{"mm"}).}

\item{background}{Background color passed to ragg devices.}

\item{scaling}{Increase to make plot bigger within the same physical size.}

\item{bitsize}{Record color as 8 bit or 16 bit. 16 bit may be useful for smoother gradients.}

\item{res}{Resolution in pixels per inch passed to ragg devices.}

\item{save}{Logical; if \code{TRUE}, also save the plot to \code{file}.}
}
\value{
An object returned by \code{\link[knitr:include_graphics]{knitr::include_graphics()}}
(rendered by knitr in HTML/PDF output).
}
\description{
\code{sameplot()} renders \code{plot} to a temporary PNG using a ragg device and returns
a knitr image include pointing to that PNG. This makes the displayed output
consistent across interactive use and knitted documents. Optionally, when
\code{save = TRUE}, the plot is also saved to \code{file} using a ragg device inferred
from the file extension.
}
\details{
When knitting to HTML (e.g., \code{rmarkdown::html_document()}), \code{sameplot()}
requires the document to be self-contained so that the generated images are
embedded in the output. Add this to your YAML:
\preformatted{
output:
  html_document:
    self_contained: true
}
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
p <- ggplot2::ggplot(mtcars, ggplot2::aes(wt, mpg)) + ggplot2::geom_point()
sameplot(p)  # display via temp PNG

# Save to a temporary folder (safe for R CMD check)
out_png <- file.path(tempdir(), "p.png")
out_tif <- file.path(tempdir(), "p.tiff")
sameplot(p, out_png, save = TRUE)
sameplot(p, out_tif, save = TRUE)
\dontshow{\}) # examplesIf}
}
