% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sampler_rec}
\alias{sampler_rec}
\title{Recycled-Momentum HMC Sampler (REC)}
\usage{
sampler_rec(
  start,
  distr_name = NULL,
  distr_params = NULL,
  epsilon = 0.5,
  L = 10,
  alpha = 0.1,
  iterations = 1024L,
  weights = NULL,
  custom_density = NULL
)
}
\arguments{
\item{start}{Vector. Starting position of the sampler.}

\item{distr_name}{Name of the distribution from which to sample from.}

\item{distr_params}{Distribution parameters.}

\item{epsilon}{Size of the leapfrog step}

\item{L}{Number of leapfrog steps per iteration}

\item{alpha}{Recycling factor, from -1 to 1 (see Details).}

\item{iterations}{Number of iterations of the sampler.}

\item{weights}{If using a mixture distribution, the weights given to each constituent distribution. If none given, it defaults to equal weights for all distributions.}

\item{custom_density}{Instead of providing names, params and weights, the user may prefer to provide a custom density function.}
}
\value{
A named list containing
\enumerate{
\item{Samples: the history of visited places (an n x d x c array, n = iterations; d = dimensions; c = chain index, with c==1 being the 'cold chain')}
\item{Momentums: the history of momentum values (an n x d matrix, n = iterations; d = dimensions). Nothing is proposed in the first iteration (the first iteration is the start value) and so the first row is NA}
\item{Acceptance Ratio: The proportion of proposals that were accepted (for each chain).}
}
}
\description{
Recycled-Momentum HMC is a sampling algorithm that uses Hamiltonian Dynamics to approximate a posterior distribution. Unlike in standard HMC, proposals are autocorrelated, as the momentum of the current trajectory is not independent of the last trajectory, but is instead updated by a parameter alpha (see Details).
}
\details{
While in HMC the momentum in each iteration is an independent draw,, here the momentum of the last utterance \eqn{p^{n-1}} is also involved. In each iteration, the momentum \eqn{p} is obtained as follows \deqn{p \gets \alpha \times p^{n-1} + (1 - \alpha^2)^{\frac{1}{2}} \times v}; where \eqn{v \sim N(0, I)}.

Recycled-Momentum HMC does not support discrete distributions.

This algorithm has been used to model human data in \insertCite{castillo2024ExplainingFlawsHuman;textual}{samplr}
}
\examples{

result <- sampler_rec(
    distr_name = "norm", distr_params = c(0,1), 
    start = 1, epsilon = .01, L = 100
)
cold_chain <- result$Samples
}
\references{
\insertAllCited{}
}
