% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_mesos.R
\name{setup_mesos}
\alias{setup_mesos}
\title{Simply create qmd-files and yml-files for mesos reports}
\usage{
setup_mesos(
  main_directory = character(),
  mesos_var_subfolder = character(),
  files_to_process,
  mesos_df,
  files_taking_title = c("index.qmd", "report.qmd"),
  read_syntax_pattern = "qs::qread\\\\('",
  read_syntax_replacement = "qs::qread('../../",
  qmd_regex = "\\\\.qmd",
  subtitle_separator = " - ",
  prefix = "{{< include \\"",
  suffix = "\\" >}}"
)
}
\arguments{
\item{main_directory}{String, path to where the _metadata.yml, stub QMD-files
and their subfolders are created.}

\item{mesos_var_subfolder}{String, optional name of a subfolder of the
mesos_var folder in where to place all mesos_group folders.}

\item{files_to_process}{Character vector of files used as templates for the mesos stubs.}

\item{mesos_df}{List of single-column data frames where each variable is a
mesos variable, optionally with a variable label indicating its pretty name.
The values in each variable are the mesos groups. NA is silently ignored.}

\item{files_taking_title}{Character vector of files for which titles should
be set. Optional but recommended.}

\item{read_syntax_pattern, read_syntax_replacement}{Optional strings, any
regex pattern to search and replace in the qmd-files. If NULL, will ignore it.}

\item{qmd_regex}{String. Experimental feature for allowing Rmarkdown, not yet tested.}

\item{subtitle_separator}{String or NULL. If a string will add title and subtitle
fields to the _metadata.yml-files in the deepest child folders. The title is
the mesos_group. The subtitle is a concatenation of the folder name of the
main_directory and the mesos_var label.}

\item{prefix, suffix}{String for the include section of the stub qmd files.}
}
\description{
Simply create qmd-files and yml-files for mesos reports
}
