% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotKO.R
\name{plotKO}
\alias{plotKO}
\title{Plot KO network}
\usage{
plotKO(
  X,
  gKO,
  q = 0.99,
  annotate = TRUE,
  nCategories = 20,
  fdrThreshold = 0.05
)
}
\arguments{
\item{X}{List. Output from `scTenifoldKnk` function.}

\item{gKO}{Character. Gene symbol of simulated knockout gene.}

\item{q}{Numeric. Edge-weight quantile used to threshold weak edges (default
0.99).}

\item{annotate}{Logical. If TRUE, perform enrichment annotation and display
pies on nodes (default TRUE).}

\item{nCategories}{Integer. Maximum number of enrichment categories to show
in the legend when annotation is requested (default 20).}

\item{fdrThreshold}{Numeric. Adjusted p-value cutoff (FDR) for reporting
enriched terms (default 0.05).}
}
\value{
Invisibly returns NULL. The primary purpose is plotting the network
 as a side effect.
}
\description{
Generate and plot a KO-centered subnetwork from the output of
`scTenifoldKnk`. The function selects genes with significant differential
regulation, extracts their interactions from the reconstructed WT network,
filters edges by weight quantile, and displays the network. When
`annotate = TRUE` the function queries enrichment databases and overlays
category pies on nodes and a legend of significant terms.
}
\details{
Plot a KO-centered subnetwork and (optionally) annotate with enrichment
}
\examples{
\dontrun{
res <- scTenifoldKnk(countMatrix, gKO = "G100")
plotKO(res, gKO = "G100")
}

}
