% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_scdf.R
\name{read_scdf}
\alias{read_scdf}
\title{Load single-case data from files}
\usage{
read_scdf(
  file,
  cvar = "case",
  pvar = "phase",
  dvar = "values",
  mvar = "mt",
  sort_cases = FALSE,
  phase_names = NULL,
  type = NA,
  na = c("", "NA"),
  sort.labels = NULL,
  phase.names = NULL,
  ...
)
}
\arguments{
\item{file}{Either a character string defining the file to be loaded (e.g.
\code{"SC_Anita.csv"} (if left empty a dialog box for choosing will be opened)
or a data.frame.}

\item{cvar}{Sets the variable name of the "case" variable. Defaults to
\code{"case"}.}

\item{pvar}{Sets the variable name of the "phase" variable. Defaults to
\code{"phase"}.}

\item{dvar}{Sets the variable name of the "values" variable. Defaults to
\code{"values"}.}

\item{mvar}{Sets the variable name of the "mt" variable. Defaults to \code{"mt"}.}

\item{sort_cases, sort.labels}{If set TRUE, the resulting list is sorted by
label names (alphabetically increasing).}

\item{phase_names, phase.names}{A character vector with phase names. Defaults
to the phase names provided in the phase variable.}

\item{type}{Format of the file to be loaded. Either "csv", "xlsx", "xls",
"excel", "yml" is possible. By default (NA) the type is extracted from the
file extension.}

\item{na}{Character vector of strings to interpret as missing values.}

\item{\dots}{Further arguments passed to the respective read function.}
}
\value{
Returns a single-case data frame. See \code{\link{scdf}} to learn
about the format of these data frames.
}
\description{
Use the \code{read_scdf} function to load single-case data csv, excel, or yaml
files.
}
\examples{

## Read SC-data from a file named "study1.csv" in your working directory
# study1 <- read_scdf("study1.csv")

## Read SC-data from a .csv-file with semicolon as field and comma as decimal separator
# study2 <- read_scdf("study2.csv", sep = ";", dec = ",")

## write_scdf and read_scdf
filename <- file.path(tempdir(), "test.csv")
write_scdf(exampleA1B1A2B2_zvt, filename)
dat <- read_scdf(filename, cvar = "case", pvar = "part", dvar = "zvt", mvar = "day")
res1 <- describe(exampleA1B1A2B2_zvt)$descriptives
res2 <- describe(dat)$descriptives
all.equal(res1,res2)

}
\seealso{
\code{\link[=read.table]{read.table()}}, \code{\link[=readRDS]{readRDS()}}

Other io-functions: 
\code{\link{convert}()},
\code{\link{write_scdf}()}
}
\author{
Juergen Wilbert
}
\concept{io-functions}
\keyword{io}
