% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{get_select_params}
\alias{get_select_params}
\title{Get Selection Parameters for Fire Simulations}
\usage{
get_select_params(fires_hist_size, sim_perimeters_size, n_years)
}
\arguments{
\item{fires_hist_size}{Numeric vector of historical fire sizes.}

\item{sim_perimeters_size}{Numeric vector of simulated fire sizes.}

\item{n_years}{Integer. Number of years considered in the historical dataset.}
}
\value{
An integer value representing the ratio between the total simulated area
and the average annual historical burned area.
Larger values indicate that the simulation covers several historical fire seasons.
}
\description{
This function calculates a selection parameter that represents how many times
the simulated burned area covers, on average, the historical annual burned area.
}
\details{
The parameter is calculated as:
\deqn{ \text{param} = \left\lfloor \frac{\sum(\text{sim\_perimeters\_size})}{\sum(\text{fires\_hist\_size}) / n\_years} \right\rfloor }

Where:
\itemize{
  \item \eqn{\sum(\text{fires\_hist\_size}) / n\_years} = average historical burned area per year.
  \item \eqn{\sum(\text{sim\_perimeters\_size})} = total simulated burned area.
}
}
\examples{
# Example with toy data
hist_sizes <- c(100, 200, 150, 300)
sim_sizes  <- c(80, 120, 200, 250, 300)

get_select_params(fires_hist_size = hist_sizes,
                  sim_perimeters_size = sim_sizes,
                  n_years = 4)

}
\seealso{
[check_fire_data]
}
