% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_plot_bbar.R
\name{scf_plot_bbar}
\alias{scf_plot_bbar}
\title{Stacked Bar Chart of Two Discrete Variables in SCF Data}
\usage{
scf_plot_bbar(
  design,
  rowvar,
  colvar,
  scale = c("percent", "count"),
  percent_by = c("total", "row", "col"),
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  fill_colors = NULL,
  row_labels = NULL,
  col_labels = NULL
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}. Must contain five implicates with replicate weights.}

\item{rowvar}{A one-sided formula for the x-axis grouping variable (e.g., \code{~edcl}).}

\item{colvar}{A one-sided formula for the stacked fill variable (e.g., \code{~racecl}).}

\item{scale}{Character. One of \code{"percent"} (default) or \code{"count"}.}

\item{percent_by}{Character. One of \code{"total"} (default), \code{"row"}, or \code{"col"} — determines normalization base when \code{scale = "percent"}.}

\item{title}{Optional character string for the plot title.}

\item{xlab}{Optional character string for the x-axis label.}

\item{ylab}{Optional character string for the y-axis label.}

\item{fill_colors}{Optional vector of fill colors to pass to \code{ggplot2::scale_fill_manual()}.}

\item{row_labels}{Optional named vector to relabel \code{row} categories (x-axis).}

\item{col_labels}{Optional named vector to relabel \code{col} categories (legend).}
}
\value{
A \code{ggplot2} object.
}
\description{
Visualizes a discrete-discrete bivariate distribution using stacked bars
based on pooled cross-tabulations from \code{\link[=scf_xtab]{scf_xtab()}}. Use this function to
visualize the relationship between two discrete variables.
}
\section{Implementation}{

This function calls \code{\link[=scf_xtab]{scf_xtab()}} to estimate the joint distribution of two
categorical variables across multiply-imputed SCF data. The result is translated
into a \code{ggplot2} stacked bar chart using pooled counts or normalized percentages.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("plot_bbar_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Stacked bar chart: education by ownership
scf_plot_bbar(scf2022, ~own, ~edcl)

# Example for real analysis: Column percentages instead of total percent
scf_plot_bbar(scf2022, ~own, ~edcl, percent_by = "col")

# Example for real analysis: Raw counts (estimated number of households)
scf_plot_bbar(scf2022, ~own, ~edcl, scale = "count")

# Do not implement these lines in real analysis: Cleanup for package check
unlink(td, recursive = TRUE, force = TRUE)

}
