% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create_grouped_functions.R
\name{make_approx_functions_from_dataframe}
\alias{make_approx_functions_from_dataframe}
\title{make_approx_functions_from_dataframe}
\usage{
make_approx_functions_from_dataframe(
  dataframe,
  group_vars,
  x_var,
  y_var,
  approx_func
)
}
\arguments{
\item{dataframe}{A data.frame with your data.}

\item{group_vars}{The variable names in the dataframe that subset the data into the various groups.}

\item{x_var}{The name of the x variable in the dataframe}

\item{y_var}{The name of the y variable in the dataframe.}

\item{approx_func}{A function that takes in two arguments, an x vector and a y vector. Make sure it can handle vectors of length 0 (if that can happen in your data).}
}
\value{
A function of the form function(groupvar1, groupvar2, ..., x).
}
\description{
make_approx_functions_from_dataframe
}
\examples{
# Generating example data.
# Consider we have equity prices for several days and times.
RICs = c("BARC.L", "VOD.L", "IBM.L")
Dates = as.Date(c("11-11-2019", "12-11-2019", "13-11-2019",
           "14-11-2019", "15-11-2019"), format="\%d-\%m-\%Y")
times = seq(0,28800, length.out = 10) # The number of seconds into the trading day.
dd = expand.grid(TIME = times, Date = Dates, RIC = RICs)
dd = merge(dd, data.frame(RIC = RICs, PRICE = c(160.00, 162.24, 137.24)))
randomness = rlnorm(dim(dd)[1])
dd$PRICE = dd$PRICE * cumprod(randomness)

approx_func = function(x,y){approxfun(x, y)}
dispatched_approxfun = make_approx_functions_from_dataframe(dd,
                                group_vars = c("RIC", "Date"),
                                 x_var = "TIME", y_var = "PRICE",
                                                      approx_func)
dispatched_approxfun("BARC.L", Dates[2], c(100, 156, 6045))
}
