library(schumaker)
library(testthat)

context("Testing the schumaker package")

x = c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
y = x ^ 2

schumaker::impute_gradients(x, y)


sp_all = Schumaker(x,y)
sp = sp_all$Spline
sp1 = sp_all$DerivativeSpline
sp2 = sp_all$SecondDerivativeSpline

xarray = c(0, 0.5, 1, 2, 3, 4, 5, 6, 6.6, 7, 8, 9, 10, 12)
yarray0 = sp(xarray)
yarray1 = sp1(xarray)
yarray2 = sp2(xarray)

test_that("The bug: Testing that all second derivatives are positive. Some values and gradients might be negative however", {
  expect_true(all(yarray0 >= 0))
  expect_true(all(yarray1 >= 0))
  expect_true(all(yarray2 >= 0))
})
