% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correltable.R
\name{correltable}
\alias{correltable}
\title{Create correlation table (with stars for significance)
for scientific publication}
\usage{
correltable(
  data,
  vars = NULL,
  var_names = vars,
  vars2 = NULL,
  var_names2 = vars2,
  method = "pearson",
  use = "pairwise",
  round_n = 2,
  tri = "upper",
  cutempty = FALSE,
  colnum = FALSE,
  html = FALSE,
  strata = NULL
)
}
\arguments{
\item{data}{The input dataset.}

\item{vars}{A list of the names of variables to correlate,
e.g. c("Age","height","WASI"),
if NULL, all variables in \code{data} will be used.}

\item{var_names}{An optional list to rename the \code{vars} colnames
in the output table, e.g. c("Age (years)","Height (inches)","IQ").
Must match \code{vars} in length. If not supplied, \code{vars} will be printed as is.}

\item{vars2}{If cross-correlation between two sets of variables
is desired, add a second list of  variables to correlate with
\code{vars}; Overrides \code{tri}, \code{cutempty}, and \code{colnum}.}

\item{var_names2}{An optional list to rename the \code{vars2} colnames
in the output table If not supplied, \code{vars2} will be printed as is.}

\item{method}{Type of correlation to calculate c("pearson", "spearman"),
based on \code{stats::cor}, default = "pearson".}

\item{use}{Use pairwise.complete.obs or restrict to complete cases
c("pairwise", "complete"), based on \code{stats::cor}, default = "pairwise".}

\item{round_n}{The number of decimal places to
round all output to (default=2).}

\item{tri}{Select output formatting c("upper", "lower","all");
KEEP the upper triangle, lower triangle, or all values, default ="upper"}

\item{cutempty}{If keeping only upper/lower triangle with \code{tri},
cut empty row/column, default=FALSE.}

\item{colnum}{For more concise column names, number row names and
just use corresponding numbers as column names,
default=FALSE, if TRUE overrides cutempty.}

\item{html}{Format as html in viewer or not (default=F, print in console),
needs library(htmlTable) installed.}

\item{strata}{Split table by a 2-level factor variable
with level1 in the upper and level2 in the lower triangle
must have 2+ cases per level, cannot be combined with vars2}
}
\value{
Output Table 1
}
\description{
The \code{correltable} function can be used to create correlation
table (with stars for significance) for scientific publication
This is intended to summarize correlations between (\code{vars})
from an input dataset (\code{data}).
Correlations are based on \code{stats::cor}, \code{use} and \code{method}
follow from that function.
Stars indicate significance: \verb{*p<.05, **p<.01, ***p<.001}
For formatting, variables can be renamed, numbers can be rounded,
upper or lower triangle only can be selected (or whole matrix),
and empty columns/rows can be dropped if using triangles.
For more compact columns, variable names can be numbered in the
rows and column names will be corresponding numbers.
If only cross-correlation between two sets of variables is desired
(no correlations within a set of variables),
\code{vars2} and \code{var_names} can be used.
This function will drop any non-numeric variables by default.
Requires \code{tidyverse} and \code{stats} libraries.
}
\examples{
\dontrun{
correltable(data = psydat)
correltable(
  data = psydat, vars = c("Age", "Height", "iq"),
  tri = "lower", html = TRUE
)
correltable(
  data = psydat, vars = c("Age", "Height", "iq"),
  tri = "lower", html = TRUE, strata = "Sex"
)
correltable(
  data = psydat, vars = c("Age", "Height", "iq"),
  var_names = c("Age (months)", "Height (inches)", "IQ"),
  tri = "upper", colnum = TRUE, html = TRUE
)
correltable(
  data = psydat, vars = c("Age", "Height", "iq"),
  var_names = c("Age (months)", "Height (inches)", "IQ"),
  vars2 = c("depressT", "anxT"),
  var_names2 = c("Depression T", "Anxiety T"), html = TRUE
)
}
}
