% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_base_text.R
\name{set_base_text}
\alias{set_base_text}
\title{Set base text parameters of an scplot object}
\usage{
set_base_text(object, ...)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{...}{List with text parameters (\verb{"family", "face", "colour", "size", "hjust", "vjust", "angle", "lineheight", "margin"}). See \code{\link[=element_text]{element_text()}}.}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}).
}
\description{
Sets the base text parameters for all text elements in an \code{scplot} object.
}
\details{
This function modifies the \code{text} element in the \code{theme} list of the
\code{scplot} object, allowing you to define default text properties such as font
family, face, color, size, alignment, angle, line height, and margin
using parameters similar to those in \code{element_text()}.
}
