% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDA_M.R
\name{SDA_M}
\alias{SDA_M}
\title{Symmetrized Data Aggregation for one-sample t-test}
\usage{
SDA_M(
  dat,
  alpha,
  Omega,
  nonsparse = FALSE,
  stable = TRUE,
  kwd = c("lasso", "de-lasso", "innovate", "pfa"),
  scale = TRUE
)
}
\arguments{
\item{dat}{a n by p data matrix}

\item{alpha}{the FDR level}

\item{Omega}{the inverse covariance matrix; if it is missing, it will be estimated
by the glasso package.}

\item{nonsparse}{If it is TRUE, the covariance matrix will be estimated by the POET
package; otherwise it will be fitted by glasso by default.}

\item{stable}{If it is TRUE, the sample will be randomly splitted \eqn{B=10} times for stability
performance; otherwise, only single sample-splitting is used.}

\item{kwd}{various methods for calculating the test statistics from the first part of data}

\item{scale}{If it is TRUE, the test statistic from the first part of data will be standardized.}
}
\value{
the indices of the hypotheses rejected by the SDA method
}
\description{
This is the main function in the SDA paper.
Other commonly used test statistics for the first part of data are also allowed in this function.
}
\details{
We provide other commonly used test statistics for the first part of sample. These include
the de-biased lasso, innovated transformation, and factor-adjusted test statistics.
}
\examples{
n = 50
p = 100
rho = 0.8
Sig = matrix(rho, p, p)
diag(Sig) = 1
dat <- MASS::mvrnorm(n, rep(0, p), Sig)
mu = rep(0, p)
mu[1:as.integer(0.1*p)]=0.5
dat = dat+rep(1, n)\%*\%t(mu)
alpha = 0.2
out = SDA_M(dat, alpha, solve(Sig), kwd='lasso')
print(out)

}
