% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic.R
\name{genetic_genomic_varcov}
\alias{genetic_genomic_varcov}
\title{Genetic-Genomic Variance-Covariance Matrix (A)}
\usage{
genetic_genomic_varcov(
  gmat,
  Gamma = NULL,
  reliability = NULL,
  C_gebv_g = NULL,
  square = TRUE
)
}
\arguments{
\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits)}

\item{Gamma}{Genomic variance-covariance matrix (n_traits x n_traits).
If NULL, assumed equal to gmat (perfect prediction).}

\item{reliability}{Optional. Reliability of GEBVs (r² = squared correlation
between GEBV and true BV). Can be:
- Single value (applied to all traits)
- Vector of length n_traits (one per trait)
- NULL (default): assumes C_g,\eqn{\gamma} = Gamma (unbiased GEBVs with reliability = 1)}

\item{C_gebv_g}{Optional. Direct specification of Cov(\eqn{\gamma}, g) matrix (t x t).
If provided, overrides reliability parameter.}

\item{square}{Logical. If TRUE (default), returns (2t × 2t) square matrix
as required for GESIM. If FALSE, returns (2t × t) rectangular form for LMSI.}
}
\value{
Genetic-genomic covariance matrix:
  - If square = TRUE: (2t × 2t) symmetric matrix for GESIM/eigen indices
  - If square = FALSE: (2t × t) rectangular matrix for LMSI
  where t is the number of traits
}
\description{
Computes the genetic-genomic covariance matrix (A) as defined in Chapter 8
(Equation 8.12) for GESIM and related genomic eigen selection indices.

Structure: A = [[C, C_g-gamma], [C_gamma-g, \eqn{\Gamma}]]  (2t x 2t, square symmetric)

where:
- C = Var(g) = true genotypic variance-covariance (t x t)
- \eqn{\Gamma} = Var(\eqn{\gamma}) = genomic variance-covariance (t x t)
- C_g-gamma = Cov(g, \eqn{\gamma}) = covariance between true BVs and GEBVs (t x t)
- C_gamma-g = Cov(\eqn{\gamma}, g) = transpose of C_g-gamma (t x t)
}
\details{
The genetic-genomic matrix relates selection on phenotypes + GEBVs to
expected genetic gains.

**For GESIM (Chapter 8):** Requires the full (2t × 2t) square matrix for
the eigenproblem: (\eqn{\Phi}^(-1) A - \eqn{\lambda}I)b = 0

**For LMSI/CLGSI (Chapter 4):** Can use the rectangular (2t × t) form
in the equation: b = P^(-1) G w, where G is (2t × t).

When reliability is provided:
- \eqn{C_{\gamma g}} = diag(\eqn{\sqrt{r^2}}) %*% gmat (assumes accuracy scales genetic covariance)

When reliability is NULL:
- \eqn{C_{\gamma g}} = Gamma (assumes unbiased GEBVs, perfect prediction)
}
\examples{
\dontrun{
# Generate example data
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Simulate genomic covariance
Gamma <- gmat * 0.8

# For GESIM: Get square (2t × 2t) matrix
A_square <- genetic_genomic_varcov(gmat, Gamma, reliability = 0.7)
print(dim(A_square)) # Should be 14 x 14 (2t × 2t)

# For LMSI: Get rectangular (2t × t) matrix
A_rect <- genetic_genomic_varcov(gmat, Gamma, reliability = 0.7, square = FALSE)
print(dim(A_rect)) # Should be 14 x 7 (2t × t)
}
}
\references{
Cerón-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Chapters 4 & 8.
}
