% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotypic_indices.R
\name{lpsi}
\alias{lpsi}
\title{Combinatorial Linear Phenotypic Selection Index}
\usage{
lpsi(ncomb, pmat, gmat, wmat, wcol = 1, GAY, excluding_trait = NULL)
}
\arguments{
\item{ncomb}{Number of traits per combination}

\item{pmat}{Phenotypic variance-covariance matrix}

\item{gmat}{Genotypic variance-covariance matrix}

\item{wmat}{Weight matrix}

\item{wcol}{Weight column number if more than one weight set (default: 1)}

\item{GAY}{Genetic advance of comparative trait (optional)}

\item{excluding_trait}{Optional. Traits to exclude from combinations. Can be:
(1) numeric vector of trait indices (e.g., c(1, 3)),
(2) character vector of trait names (e.g., c("sypp", "dtf")),
(3) data frame/matrix columns with trait data (trait names extracted from column names).
When specified, only combinations that do NOT contain any of these traits are returned.}
}
\value{
Data frame of all possible selection indices with metrics (GA, PRE, Delta_G, rHI, hI2)
}
\description{
Build all possible Smith-Hazel selection indices from trait combinations,
with optional exclusion of specific traits.

This function systematically evaluates indices for all combinations of
ncomb traits, which is useful for identifying the most efficient subset
of traits for selection.
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
wmat <- weight_mat(weight)

# Build all 3-trait indices
result <- lpsi(ncomb = 3, pmat = pmat, gmat = gmat, wmat = wmat, wcol = 1)

# Exclude specific traits
result <- lpsi(
  ncomb = 3, pmat = pmat, gmat = gmat, wmat = wmat,
  excluding_trait = c(1, 3)
)
}
}
