% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{plot.reliability_table}
\alias{plot.reliability_table}
\title{Function for plotting the measurement model reliability metrics of a PLS model}
\usage{
\method{plot}{reliability_table}(x, ...)
}
\arguments{
\item{x}{A \code{reliability_table} object from a SEMinR PLS model. This can be accessed
as the \code{reliability} element of the PLS model summary object.}

\item{...}{All other arguments inherited from \code{plot}.}
}
\description{
\code{plot.reliability_table} generates an easy to read visualization of the rhoA, Cronbachs
  alpha, and Composite Reliability for all constructs. The plot visualizes the metrics
  in such a way as to draw meaning from not only the absolute values, but their relative
  values too.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
 composite("Image",        multi_items("IMAG", 1:5)),
 composite("Expectation",  multi_items("CUEX", 1:3)),
 composite("Value",        multi_items("PERV", 1:2)),
 composite("Satisfaction", multi_items("CUSA", 1:3))
)

#  structural model: note that name of the interactions construct should be
#  the names of its two main constructs joined by a '*' in between.
mobi_sm <- relationships(
 paths(to = "Satisfaction",
       from = c("Image", "Expectation", "Value"))
)

mobi_pls <- estimate_pls(mobi, measurement_model = mobi_mm, structural_model = mobi_sm)
plot(summary(mobi_pls)$reliability)

}
