% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivityIxJ.R
\name{exact.score.sen.IxJ}
\alias{exact.score.sen.IxJ}
\title{Exact Sensitivity Analysis for Sum Score (Ordinal) Tests in I by J Tables}
\usage{
exact.score.sen.IxJ(
  obs.table,
  gamma,
  delta,
  row = "treatment",
  verbose = FALSE,
  treatment.scores,
  outcome.scores
)
}
\arguments{
\item{obs.table}{A matrix or table object representing the observed contingency table.}

\item{gamma}{A nonnegative scalar.}

\item{delta}{A binary vector with no more than two unique values, corresponding
to treatment levels. The length must match the number of treatments
(rows of \code{obs.table} if \code{row = "treatment"}, or columns if \code{row = "outcome"}).
Must have a monotone trend matching the treatment ordering.}

\item{row}{A string indicating whether rows represent "outcome" or "treatment".
Must be either "outcome" or "treatment". Default is "treatment".}

\item{verbose}{A logical flag indicating whether to print progress messages.
Default is \code{FALSE}.}

\item{treatment.scores}{A numeric vector specifying the scores for each treatment level.
Must have the same length as the number of treatments and
exhibit a monotone trend.}

\item{outcome.scores}{A numeric vector specifying the scores for each outcome level.
Must have the same length as the number of outcomes and
exhibit a monotone trend.}
}
\value{
A list containing:
\describe{
\item{rct.prob}{Probability under Randomized Controlled Trial (RCT) with \code{u_allocation} set to zero.}
\item{max.prob}{Maximum probability found across all allocations in \code{u_space}.}
\item{maximizer}{The \code{u_allocation} vector that yields \code{max.prob}.}
\item{gamma}{Extracted gamma value from the generic bias model.}
\item{delta}{The delta vector}
\item{obs.stat}{The observed test statistic based on the observed table and the assigned scores.}
\item{obs.table}{The observed table.}
}
}
\description{
This function computes exact p-values for score-based sensitivity analysis in I by J
contingency tables under the generic bias model. It is specifically designed for
ordinal data where both treatment levels and outcomes have a natural ordering,
and tests for trend using assigned scores.
}
\details{
The score test assumes both treatments and outcomes are ordinal with monotone trends.
The test statistic is computed as the sum of products of cell counts with their
corresponding treatment and outcome scores. The function automatically generates an
appropriate u-space for score tests, focusing on allocations that respect the
ordinal nature of the data.
}
\examples{
\donttest{
## Example 1: Binary outcome table (2 by 2)
obs.table <- matrix(c(12, 18, 17, 3), ncol = 2, byrow = TRUE,
                   dimnames = list(treatment = c("control", "treated"),
                                  outcome = c("failure", "success")))

# Perform score-based sensitivity analysis
result_2x2 <- exact.score.sen.IxJ(obs.table = obs.table,
                                  gamma = 0.5,
                                  delta = c(0, 1),
                                  treatment.scores = c(0, 1),
                                  outcome.scores = c(0, 1))
result_2x2

## Example 2: Three-level ordinal outcome (3 by 3)
obs.table <- matrix(c(12, 18, 17, 3, 12, 25, 0, 3, 4),
                   ncol = 3, byrow = FALSE,
                   dimnames = list(treatment = c("low", "medium", "high"),
                                  outcome = c("poor", "fair", "good")))

# Test for trend with ordinal scores
result_3x3 <- exact.score.sen.IxJ(obs.table = obs.table,
                                  gamma = 0.5,
                                  delta = c(0, 1, 1),
                                  treatment.scores = c(0, 1, 2),
                                  outcome.scores = c(1, 2, 3))
result_3x3
}

}
\seealso{
\code{\link{exact.general.sen.IxJ}} for general test statistics,
\code{\link{possible.table}} for generating reference sets
}
