% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_utils.R
\name{st_filter_by_genre}
\alias{st_filter_by_genre}
\title{Create Genre-Based Filter}
\usage{
st_filter_by_genre(
  genres = NULL,
  sub_genres = NULL,
  exclude_genres = FALSE,
  auth_token = NULL
)
}
\arguments{
\item{genres}{Character vector. Game genres to filter (e.g., "Puzzle", "Action")}

\item{sub_genres}{Character vector. Game sub-genres to filter (e.g., "Word", "Match-3")}

\item{exclude_genres}{Logical. Whether to exclude these genres (FALSE = include)}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
Character string containing the filter ID
}
\description{
Creates a filter for apps in specific game genres or sub-genres.
}
\examples{
\dontrun{
# Get Puzzle and Word games
filter_id <- st_filter_by_genre(
  genres = "Puzzle",
  sub_genres = "Word"
)

# Exclude Action and Shooter games
filter_id <- st_filter_by_genre(
  genres = c("Action", "Shooter"),
  exclude_genres = TRUE
)
}

}
