% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_metrics.R
\name{st_metrics}
\alias{st_metrics}
\title{Fetch Sensor Tower Metrics for Apps}
\usage{
st_metrics(
  os,
  app_id = NULL,
  ios_app_id = NULL,
  android_app_id = NULL,
  unified_app_id = NULL,
  start_date = NULL,
  end_date = NULL,
  countries,
  date_granularity,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  verbose = TRUE
)
}
\arguments{
\item{os}{Character. Required. Operating system: "ios", "android", or "unified".
This determines which platform's data is returned.}

\item{app_id}{Character string. Can be a unified app ID, iOS app ID, or Android package name.}

\item{ios_app_id}{Character string. iOS app ID (optional).}

\item{android_app_id}{Character string. Android package name (optional).}

\item{unified_app_id}{Character string. Sensor Tower unified ID (24-char hex).}

\item{start_date}{Date object or character string (YYYY-MM-DD). Start date.}

\item{end_date}{Date object or character string (YYYY-MM-DD). End date.}

\item{countries}{Character vector. Country codes (e.g., "US", "GB", "JP", or "WW" for worldwide). Required.}

\item{date_granularity}{Character. One of "daily", "weekly", "monthly", "quarterly". Required.}

\item{auth_token}{Character string. Sensor Tower API token.}

\item{verbose}{Logical. Print progress messages.}
}
\value{
A tibble with columns: app_id, app_id_type, date, country, revenue, downloads
}
\description{
Retrieves metrics for apps. The OS parameter controls which platform's data is returned,
regardless of which app IDs are provided. The function will automatically look up
the appropriate IDs if needed.
}
\details{
The OS parameter controls what data is returned:

- os = "ios": Returns iOS data only
- os = "android": Returns Android data only
- os = "unified": Returns combined iOS + Android data (as separate rows)

The function will automatically look up the appropriate IDs based on the OS parameter.
For example, if you provide a unified_app_id but set os = "ios", it will look up
the iOS app ID and return iOS-only data.
}
\examples{
\dontrun{
# Get iOS data only
ios_metrics <- st_metrics(
  os = "ios",
  ios_app_id = "1195621598", # Homescapes iOS
  countries = "US",
  date_granularity = "daily",
  start_date = Sys.Date() - 30,
  end_date = Sys.Date() - 1
)

# Get unified data from a unified ID
unified_metrics <- st_metrics(
  os = "unified",
  unified_app_id = "5ba4585f539ce75b97db6bcb",
  countries = "US",
  date_granularity = "daily"
)

# Get iOS data from Android ID (automatic lookup)
ios_from_android <- st_metrics(
  os = "ios",
  android_app_id = "com.king.candycrushsaga",
  countries = "WW",
  date_granularity = "monthly"
)

# Get unified data from platform IDs
unified_from_platforms <- st_metrics(
  os = "unified",
  ios_app_id = "1195621598",
  android_app_id = "com.playrix.homescapes",
  countries = "US",
  date_granularity = "daily"
)
}

}
