% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_top_charts.R
\name{st_top_charts}
\alias{st_top_charts}
\title{Fetch Top Apps by Various Metrics}
\usage{
st_top_charts(
  measure = "revenue",
  os,
  comparison_attribute = "absolute",
  time_range = "month",
  date = NULL,
  category = NULL,
  regions,
  end_date = NULL,
  limit = 20,
  offset = NULL,
  device_type = NULL,
  custom_fields_filter_id = NULL,
  custom_tags_mode = NULL,
  data_model = "DM_2025_Q2",
  auth_token = NULL,
  base_url = "https://api.sensortower.com",
  enrich_response = TRUE,
  deduplicate_apps = TRUE
)
}
\arguments{
\item{measure}{Character string. Metric to measure. Must be one of:
- **Revenue/Downloads**: "revenue" (default), "units" 
- **Active Users**: "DAU", "WAU", "MAU"}

\item{os}{Character string. Operating System. Must be one of
"ios", "android", or "unified". Required.}

\item{comparison_attribute}{Character string. Comparison attribute
type. Must be one of "absolute", "delta", or "transformed_delta". 
Defaults to "absolute".}

\item{time_range}{Character string. Time granularity. Must be one of
"day", "week", "month", or "quarter". Defaults to "month".
Note: "week" is not available when `measure` is "MAU".}

\item{date}{Character string or Date object. Start date for the
query in "YYYY-MM-DD" format. Defaults to the start of the current month.}

\item{category}{Character string or numeric. The ID of the category to 
filter by. **Required unless `custom_fields_filter_id` is provided**.
Use `st_categories()` to find valid IDs.}

\item{regions}{Character vector or comma-separated string. Region
codes (e.g., `"US"`, `c("US", "GB")`, `"WW"` for worldwide) to filter results. 
Required.}

\item{end_date}{Optional. Character string or Date object. End date for the
query in "YYYY-MM-DD" format, inclusive. Only used for revenue/downloads.}

\item{limit}{Optional. Integer. Maximum number of apps to return per call.
Defaults to 20.}

\item{offset}{Optional. Integer. Number of apps to skip for pagination.}

\item{device_type}{Optional. Character string. For `os = "ios"` or
`os = "unified"`: "iphone", "ipad", or "total". Defaults to `"total"`.}

\item{custom_fields_filter_id}{Optional. Character string. ID of a Sensor
Tower custom field filter to apply.}

\item{custom_tags_mode}{Optional. Character string. Required if `os` is
'unified' and `custom_fields_filter_id` is provided.}

\item{data_model}{Optional. Character string. The data model to use.
Defaults to "DM_2025_Q2". Only used for active user metrics.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{base_url}{Optional. Character string. The base URL for the API.}

\item{enrich_response}{Optional. Logical. If `TRUE` (default), enriches
the response with app metadata and custom metrics.}

\item{deduplicate_apps}{Optional. Logical. If `TRUE` (default), consolidates
apps with the same name but different platform/regional SKUs into single rows
with aggregated metrics. If `FALSE`, returns separate rows for each SKU.}
}
\value{
A [tibble][tibble::tibble] with top app data including enhanced
  custom metrics like downloads, revenue, retention rates, and more.
  For sales data (revenue/downloads), app names are automatically looked up
  using the app IDs since the sales endpoint doesn't provide app names natively.
  
  **Revenue Units**: Revenue values are standardized to base currency units (dollars,
  euros, etc.) for consistency across all sensortowerR functions. The function provides
  a `revenue` column in base units alongside the original `revenue_absolute` (in cents).
  
  **Data Cleaning**: Numeric metric values are automatically cleaned of special 
  characters (%, $, commas) and converted to proper numeric format for analysis.
  
  **App Deduplication**: By default, apps with the same name but different 
  platform/regional SKUs are consolidated into single rows with aggregated metrics
  (downloads/revenue summed, rates/percentages averaged).
}
\description{
Retrieves top apps from Sensor Tower based on revenue, downloads ("units"), 
or active user metrics (DAU, WAU, MAU). This unified function automatically 
selects the appropriate API endpoint based on the measure specified.
}
\section{API Endpoints Used}{

  - **All Measures**: `GET /v1/\{os\}/sales_report_estimates_comparison_attributes`
  - Note: DAU/WAU/MAU measures now use the sales endpoint with custom filters for correct sorting
}

\section{Enhanced Custom Metrics}{

  The function extracts comprehensive custom metrics including:
  - Downloads: `downloads_180d_ww`, `downloads_90d_us`
  - Revenue: `revenue_180d_ww`, `revenue_90d_us`
  - Retention: `retention_1d_us`, `retention_7d_us`, `retention_30d_us`
  - Monetization: `rpd_alltime_us`, `arpu_90d_us`
  - Demographics: `male_share_us`, `female_share_us`
  - Platform: `ios_share_ww`, `android_share_ww`
}

\examples{
\dontrun{
# Top apps by revenue (default)
top_revenue <- st_top_charts(
  os = "ios",
  category = 6000,  # iOS Games
  regions = "WW"
)

# Top apps by downloads
top_downloads <- st_top_charts(
  os = "android",
  measure = "units", 
  category = 6000,
  regions = "US"
)

# Top apps by Daily Active Users with custom filter
# Custom filter URLs from Sensor Tower web interface can be used directly
# Extract the custom_fields_filter_id from the URL parameter 'uai'
top_word_puzzles <- st_top_charts(
  os = "unified",
  measure = "revenue",  # Use revenue but custom filter handles DAU sorting
  custom_fields_filter_id = "5a39e9681454d22f5a5e75ca",  # Word puzzle filter
  custom_tags_mode = "include_unified_apps",
  category = 7019,  # Puzzle category
  regions = "US",
  date = "2025-07-20",
  end_date = "2025-08-18"
)

# Custom time range and region
top_quarter <- st_top_charts(
  os = "ios",
  measure = "revenue",
  time_range = "quarter", 
  regions = "US",
  category = 6000
)
}

}
