% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_yoy_metrics.R
\name{st_yoy_metrics}
\alias{st_yoy_metrics}
\title{Year-over-Year Metrics Comparison}
\usage{
st_yoy_metrics(
  os,
  unified_app_id = NULL,
  ios_app_id = NULL,
  android_app_id = NULL,
  publisher_id = NULL,
  years = NULL,
  period_start,
  period_end,
  metrics = c("revenue", "downloads"),
  countries,
  cache_dir = NULL,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  verbose = TRUE,
  granularity,
  use_single_fetch = TRUE
)
}
\arguments{
\item{os}{Character. Required. Operating system: "ios", "android", or "unified".
This determines which platform's data is returned.}

\item{unified_app_id}{Character vector. Sensor Tower unified app ID(s). 
Must be 24-character hex format (e.g., "5ba4585f539ce75b97db6bcb").}

\item{ios_app_id}{Character vector. iOS app ID(s) (e.g., "1234567890").}

\item{android_app_id}{Character vector. Android package name(s) (e.g., "com.example.app").}

\item{publisher_id}{Character vector. Publisher ID(s) (alternative to app IDs).}

\item{years}{Integer vector. Years to compare (e.g., c(2022, 2023, 2024)).
If NULL, uses current year and previous year.}

\item{period_start}{Character string or Date. Start of the comparison period.
Can be "MM-DD" format (e.g., "01-01" for Jan 1) or a full date.
If a full date is provided, only the month and day are used.}

\item{period_end}{Character string or Date. End of the comparison period.
Can be "MM-DD" format (e.g., "03-31" for Mar 31) or a full date.
If a full date is provided, only the month and day are used.}

\item{metrics}{Character vector. Metrics to fetch. Supports "revenue", "downloads", 
"dau", "wau", and "mau". Default is both revenue and downloads.}

\item{countries}{Character vector. Country codes (e.g., "US", "GB", "JP"). Required.}

\item{cache_dir}{Character. Directory for caching API responses (optional).}

\item{auth_token}{Character string. Sensor Tower API token.}

\item{verbose}{Logical. Print progress messages.}

\item{granularity}{Character. Date granularity for the data (e.g., "daily", "monthly").}

\item{use_single_fetch}{Logical. If TRUE, uses a single API call to fetch all data.
Defaults to TRUE for efficiency.}
}
\value{
A tibble in tidy/long format with columns:
  - `app_id`: The app ID used for fetching data
  - `app_id_type`: Type of app ID ("ios", "android", or "unified")
  - `entity_id`: App or publisher ID
  - `entity_name`: App or publisher name
  - `entity_type`: "app" or "publisher"
  - `year`: Year of the data
  - `date_start`: Start date of the period (YYYY-MM-DD)
  - `date_end`: End date of the period (YYYY-MM-DD)
  - `country`: Country code
  - `metric`: The metric name (e.g., "revenue", "downloads", "dau")
  - `value`: Metric value (units depend on metric type)
  - `yoy_change`: Year-over-year change (percentage)
  - `yoy_change_absolute`: Year-over-year change (absolute value)
}
\description{
Fetches metrics for the same date range across multiple years for 
year-over-year comparisons. Allows flexible date ranges and supports
all available metrics including revenue, downloads, and active users.
}
\details{
This function is designed for year-over-year comparisons:

- **Flexible date ranges**: Compare any period (e.g., Q1, specific months, custom ranges)
- **Multiple years**: Compare across 2+ years in a single call
- **Smart date handling**: Automatically handles leap years and invalid dates
- **YoY calculations**: Includes both percentage and absolute change
- **Caching**: Reuses cached data to minimize API calls

The function will apply the same calendar period (month/day range) to each
specified year, making it easy to compare seasonal trends, campaign periods,
or any custom date range across years.
}
\examples{
\dontrun{
# Compare Q1 performance across years
q1_comparison <- st_yoy_metrics(
  os = "ios",
  ios_app_id = "553834731",  # Candy Crush iOS
  years = c(2022, 2023, 2024),
  period_start = "01-01",
  period_end = "03-31",
  countries = "US",
  metrics = c("revenue", "downloads")
)

# Compare holiday season (Nov-Dec) across years
holiday_comparison <- st_yoy_metrics(
  os = "unified",
  unified_app_id = "5ba4585f539ce75b97db6bcb",
  years = c(2021, 2022, 2023),
  period_start = "11-01",
  period_end = "12-31",
  countries = c("US", "GB", "JP"),
  metrics = c("revenue", "downloads", "dau")
)

# Compare specific campaign period using full dates
campaign_comparison <- st_yoy_metrics(
  os = "android", 
  android_app_id = "com.king.candycrushsaga",
  years = NULL,  # Uses current and previous year
  period_start = as.Date("2024-02-14"),  # Valentine's campaign
  period_end = as.Date("2024-02-28"),
  countries = c("US", "GB", "JP"),
  metrics = c("revenue", "downloads", "dau", "wau")
)
}

}
