% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forwardBackward.R
\name{forward_backward}
\alias{forward_backward}
\alias{forward_backward.hmm}
\alias{forward_backward.mhmm}
\alias{forward_backward.nhmm}
\alias{forward_backward.mnhmm}
\title{Forward and Backward Probabilities for Hidden Markov Model}
\usage{
forward_backward(model, ...)

\method{forward_backward}{hmm}(model, forward_only = FALSE, ...)

\method{forward_backward}{mhmm}(model, forward_only = FALSE, ...)

\method{forward_backward}{nhmm}(model, forward_only = FALSE, ...)

\method{forward_backward}{mnhmm}(model, forward_only = FALSE, ...)
}
\arguments{
\item{model}{A hidden Markov model.}

\item{...}{Ignored.}

\item{forward_only}{If \code{TRUE}, only forward probabilities are computed. The
default is \code{FALSE}.}
}
\value{
A \code{data.frame} with log-values of forward and backward probabilities.
}
\description{
The \code{forward_backward} function computes forward and backward
probabilities of a hidden Markov model.
}
\examples{
# Load a pre-defined MHMM
data("mhmm_biofam")

# Compute forward and backward probabilities
fb <- forward_backward(mhmm_biofam)

head(fb)

}
