% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPropAssigned.R
\name{PlotPropAssigned}
\alias{PlotPropAssigned}
\title{Plot proportion of individuals that has a parent assigned}
\usage{
PlotPropAssigned(Pedigree = NULL, DumPrefix = c("F0", "M0"), SNPd = NULL, ...)
}
\arguments{
\item{Pedigree}{dataframe where the first 3 columns are id, dam, sire.}

\item{DumPrefix}{character vector with prefixes for dummy dams (mothers) and
sires (fathers), used to distinguish between dummies and non-dummies.}

\item{SNPd}{character vector with ids of genotyped individuals
(e.g. rownames of genotype matrix).}

\item{...}{further arguments passed to \code{\link{barplot}}}
}
\value{
a 2x4 matrix with counts, returned invisibly.
}
\description{
For any pedigree, plot the proportion of individuals that has
a genotyped, dummy, observed, or no dam/sire assigned.
}
\details{
This function offers a more flexible interface to some of the plots
  included in \code{\link{SummarySeq}}
}
\examples{
PlotPropAssigned(SeqOUT_griffin$Pedigree, SNPd = rownames(Geno_griffin))

}
