% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_minimal_sets.R
\name{find_minimal_sets}
\alias{find_minimal_sets}
\title{find_minimal_sets}
\usage{
find_minimal_sets(str_vec, sep = "_")
}
\arguments{
\item{str_vec}{Character vector of set strings for which to find minimally
sufficient sets (e.g., `c("x1_x2", "x1_x2_x3")`).}

\item{sep}{Character string used as the separator between variables in each
set. Defaults to `"_"`.}
}
\value{
A character vector containing the minimally sufficient sets (i.e., sets that
are not strict supersets of any other set in `str_vec`).
}
\description{
Given a character vector of sets (each set encoded as variable names joined by
a separator), returns the subset of sets that are minimal: no returned set
is a strict superset of another. Duplicates and ordering differences are
handled according to the implementation.
}
\examples{
pairmiresult = pairmi(misimdata[,2:6])
results_probstat <- probstat(misimdata$y,pairmiresult$expanded.data,nfolds=5)
find_minimal_sets(results_probstat$xvars[results_probstat$cprob >= 0.20])
}
