% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.R
\name{sfc_cast}
\alias{sfc_cast}
\title{sfc cast}
\usage{
sfc_cast(sfc, to, close = TRUE)
}
\arguments{
\item{sfc}{geometry object to convert to a different geometry}

\item{to}{the geometry to convert to.}

\item{close}{logical indicating if polygons should be closed}
}
\description{
convert the input \code{sfc} to a different geometry
}
\examples{
df <- data.frame(
 id1 = c(1,1,1,1,1,1,1,1,2,2,2,2)
 , id2 = c(1,1,1,1,2,2,2,2,1,1,1,1)
 , x = c(0,0,1,1,1,1,2,2,3,4,4,3)
 , y = c(0,1,1,0,1,2,2,1,3,3,4,4)
)

pt <- sfc_point(obj = df, x = "x", y = "y", z = "id1")
mpt <- sfc_multipoint(obj = df, x = "x", y = "y", multipoint_id = "id1")
ls <- sfc_linestring(obj = df, x = "x", y = "y", linestring_id = "id1")
mls <- sfc_multilinestring(obj = df, x = "x", y = "y", multilinestring_id = "id1")
p <- sfc_polygon(
  obj = df
  , x = "x"
  , y = "y"
  , polygon_id = "id1"
  , linestring_id = "id2"
  , close = FALSE
  )
mp <- sfc_multipolygon(
  obj = df
  , x = "x"
  , y = "y"
  , multipolygon_id = "id1"
  , linestring_id = "id2"
  , close = FALSE
)

sfc_cast( pt, "LINESTRING" )
sfc_cast( mpt, "POLYGON" )
sfc_cast( ls, "POINT" )
sfc_cast( mls, "MULTIPOLYGON" )
sfc_cast( p, "POINT" )
sfc_cast( mp, "LINESTRING" )

}
