% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSS2LL.R
\name{LL2PLSS}
\alias{LL2PLSS}
\alias{plssMeridians}
\title{LL2PLSS}
\usage{
LL2PLSS(x, y, returnlevel = c("I", "S"))
}
\arguments{
\item{x}{longitude coordinates (WGS84)}

\item{y}{latitude coordinates (WGS84)}

\item{returnlevel}{'S' for "Section" or 'I' for "Intersection" (subsections)}
}
\value{
\code{sf} object with geometry and PLSS definition.
}
\description{
Uses latitude and longitude coordinates to return the PLSS section geometry from the BLM PLSS web service.
}
\details{
This function accepts geographic coordinates and returns the PLSS fabric geometry to the quarter-quarter section. \code{returnlevel} defaults to 'I' which returns smallest intersected sectional aliquot geometry, 'S' will return the section geometry of the coordinates. See https://gis.blm.gov/arcgis/rest/services/Cadastral/BLM_Natl_PLSS_CadNSDI/MapServer for details.
}
\note{
This function requires the following packages: httr, jsonlite, and sf.
}
\seealso{
\code{\link[=PLSS2LL]{PLSS2LL()}}, \code{\link[=formatPLSS]{formatPLSS()}}
}
\author{
D.E. Beaudette, Jay Skovlin, A.G. Brown
}
