% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monacoDiffEditor.R
\name{monacoDiffEditor}
\alias{monacoDiffEditor}
\title{Render an Ace monacoDiffEditor}
\usage{
monacoDiffEditor(
  valueA,
  valueB,
  language = "plaintext",
  ignoreTrimWhitespace = FALSE,
  ...,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{valueA}{\link{character}: Set text to first editor when initializing}

\item{valueB}{\link{character}: Set text to second editor when initializing}

\item{language}{\link{character}: The initial language of the auto created model in the editor. To not automatically create a model, use model: null}

\item{ignoreTrimWhitespace}{\link{logical}: Compute the diff by ignoring leading/trailing whitespace Defaults to false}

\item{...}{For more arguments, please refer to \url{https://microsoft.github.io/monaco-editor/typedoc/interfaces/editor_editor_api.editor.IDiffEditorOptions.html}}

\item{width}{\link{integer}, \link{character}: Width in pixels (optional, defaults to automatic sizing)}

\item{height}{\link{integer}, \link{character}: Height in pixels (optional, defaults to automatic sizing)}

\item{elementId}{\link{character}: An element id for the widget (a random character by default)}
}
\value{
Widget for shiny application
}
\description{
Render an Ace diff editor on an application page.
}
\examples{
if(interactive()){
    shinyEditor::monacoDiffEditor(valueA = "text1", valueB = "text2")
}
}
