% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-monaco.R
\name{updateMonacoOption}
\alias{updateMonacoOption}
\title{Update an option to monacoEditor}
\usage{
updateMonacoOption(
  outputId,
  name,
  value,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{outputId}{\link{character}: The id of the editor}

\item{name}{\link{character}: Option name. Refer to \url{https://microsoft.github.io/monaco-editor/docs.html#interfaces/editor_editor_api.editor.IEditorOptions.html}}

\item{value}{\link{character}, \link{integer}, \link{logical}: Option value. Refer to \url{https://microsoft.github.io/monaco-editor/docs.html#interfaces/editor_editor_api.editor.IEditorOptions.html}}

\item{session}{\link{environment}: The Shiny session object (from the server function of the Shiny app).}
}
\value{
No return value, called for side effects
}
\description{
Update an option to monacoEditor
}
\examples{
if(interactive()){
    shinyEditor::updateMonacoOption(outputId = "editor", name = "tabSize", value = 3)
}
}
