% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleCellHaystack-package.R
\docType{package}
\name{singleCellHaystack-package}
\alias{singleCellHaystack}
\alias{singleCellHaystack-package}
\title{singleCellHaystack: A Universal Differential Expression Prediction Tool for Single-Cell and Spatial Genomics Data}
\description{
One key exploratory analysis step in single-cell genomics data analysis is the prediction of features with different activity levels. For example, we want to predict differentially expressed genes (DEGs) in single-cell RNA-seq data, spatial DEGs in spatial transcriptomics data, or differentially accessible regions (DARs) in single-cell ATAC-seq data. 'singleCellHaystack' predicts differentially active features in single cell omics datasets without relying on the clustering of cells into arbitrary clusters. 'singleCellHaystack' uses Kullback-Leibler divergence to find features (e.g., genes, genomic regions, etc) that are active in subsets of cells that are non-randomly positioned inside an input space (such as 1D trajectories, 2D tissue sections, multi-dimensional embeddings, etc). For the theoretical background of 'singleCellHaystack' we refer to our original paper Vandenbon and Diez (Nature Communications, 2020) \doi{10.1038/s41467-020-17900-3} and our update Vandenbon and Diez (Scientific Reports, 2023) \doi{10.1038/s41598-023-38965-2}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://alexisvdb.github.io/singleCellHaystack/}
  \item \url{https://github.com/alexisvdb/singleCellHaystack}
  \item Report bugs at \url{https://github.com/alexisvdb/singleCellHaystack/issues}
}

}
\author{
\strong{Maintainer}: Alexis Vandenbon \email{alexis.vandenbon@gmail.com} (\href{https://orcid.org/0000-0003-2180-5732}{ORCID})

Authors:
\itemize{
  \item Diego Diez \email{diego10ruiz@gmail.com} (\href{https://orcid.org/0000-0002-2325-4893}{ORCID})
}

}
\keyword{internal}
