# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generate a vector to map polytomous vector to integers
#'
#' Converts class into a bijection to integers
#'
#' @param M      Number of Responses
#' @param K      Number of Attributes
#'
#' @return
#'
#' Return a matrix containing the class table
#'
#' @noRd
NULL

#' Create the K inverse bijection of attribute vectors
#'
#' Converts the class into a bijection.
#'
#' @param nClass Number of Attribute Classes
#' @param M      Number of Options
#' @param K      Number of Attributes
#'
#' @return
#'
#' Return a matrix containing the class table
#'
#' @noRd
NULL

#' Generate a vector to map binary vector to integers
#'
#' Converts class into a bijection to integers
#'
#' @param M      Number of Options
#' @param K      Number of Attributes
#'
#' @return
#'
#' Return a matrix containing the class table
#'
#' @noRd
bijectionvector <- function(K) {
    .Call(`_slcm_bijectionvector`, K)
}

#' Create a K by M^K table of attribute vectors
#'
#' @param nClass Number of Attribute Classes
#' @param M      Number of Responses
#' @param K      Number of Attributes
#'
#' @return
#'
#' Return a matrix containing the class table
#'
#' @noRd
CL_gen_invbijection_table <- function(K, M, nClass) {
    .Call(`_slcm_CL_gen_invbijection_table`, K, M, nClass)
}

#' Create a permutation table based on indices
#'
#' Generates a vector containing permutation indices.
#'
#' @param nClass Number of Attribute Classes
#' @param K      Number of Attributes
#' @param M      Number of Responses
#' @param order  Order is 1, main-effects, 2 main-effects + interactions.
#'               Highest level of interactions you want.
#' @param vv     Vector of a bijection
#' @param perm   Permutations
#'
#' @return
#' 
#' A `vec` containing indices permutated.
#' 
#' @noRd
permuteAtableIndices <- function(nClass, K, M, order, vv, perm) {
    .Call(`_slcm_permuteAtableIndices`, nClass, K, M, order, vv, perm)
}

#' Generate Multinomial Random Variable
#'
#' Sample a multinomial random variable for given probabilities.
#'
#' @param ps A `vector` for the probability of each category.
#' @param M  Number of Categories.
#'
#' @return
#' A `vector` from a multinomial with probability `ps`.
#'
#' @author
#' Steven Andrew Culpepper
#'
#' @noRd
rmultinomial <- function(ps, M) {
    .Call(`_slcm_rmultinomial`, ps, M)
}

#' Generate Truncated Normal Random Variable
#'
#' Sample a truncated random variable for given probabilities.
#'
#' @param mean  Mean of the distribution
#' @param sd    Standard deviation of the distribution
#' @param w     Upper bound limits??
#' @param b_lb  Lower bound limits??
#' @param M     Number of Responses??
#'
#' @return
#' A single random `double` value from a truncated normal.
#'
#' @author
#' Steven Andrew Culpepper
#'
#' @noRd
rTruncNorm_b <- function(mean, sd, w) {
    .Call(`_slcm_rTruncNorm_b`, mean, sd, w)
}

rTruncNorm_lb <- function(mean, sd, b_lb) {
    .Call(`_slcm_rTruncNorm_lb`, mean, sd, b_lb)
}

rTruncNorm <- function(mean, sd, w, ps, M) {
    .Call(`_slcm_rTruncNorm`, mean, sd, w, ps, M)
}

#' Generate Dirichlet Random Variable
#'
#' Sample a Dirichlet random variable.
#'
#' @param deltas A `vector` of Dirichlet parameters.
#'
#' @return
#' A `vector` from a Dirichlet.
#'
#' @author
#' Steven Andrew Culpepper
#'
#' @noRd
rDirichlet <- function(deltas) {
    .Call(`_slcm_rDirichlet`, deltas)
}

random_Q <- function(J, K) {
    .Call(`_slcm_random_Q`, J, K)
}

#' Generate tables to store the results during iterations
#'
#' Generate tables to store the results during iterations
#'
#' @param nClass   Number of Attribute Classes
#' @param M        Number of Responses
#' @param K        Number of Attributes
#' @param order    Order is 1, main-effects, 2 main-effects + interactions.
#'               Highest level of interactions you want.
#'
#' @return
#'
#' Return a list containing the tables for different parameters
#'
#' @noRd
GenerateAtable <- function(nClass, K, M, order) {
    .Call(`_slcm_GenerateAtable`, nClass, K, M, order)
}

ETAmat <- function(K, J, M, Q) {
    .Call(`_slcm_ETAmat`, K, J, M, Q)
}

BetatoTheta <- function(J, nClass, beta, Atable) {
    .Call(`_slcm_BetatoTheta`, J, nClass, beta, Atable)
}

computeLB <- function(nClass, LBtable, Atable, p, betaj, Bp, Bindices) {
    .Call(`_slcm_computeLB`, nClass, LBtable, Atable, p, betaj, Bp, Bindices)
}

identify_check <- function(Q) {
    .Call(`_slcm_identify_check`, Q)
}

eta_dina_matrix <- function(Q) {
    .Call(`_slcm_eta_dina_matrix`, Q)
}

Q_prime_matrix <- function(K, Atable, vv) {
    .Call(`_slcm_Q_prime_matrix`, K, Atable, vv)
}

pnorm_ln_lower_tail <- function(B_p_lowerbound, sigma_var_jp) {
    .Call(`_slcm_pnorm_ln_lower_tail`, B_p_lowerbound, sigma_var_jp)
}

pnorm_ln_upper_tail <- function(B_p_lowerbound, sigma_var_jp) {
    .Call(`_slcm_pnorm_ln_upper_tail`, B_p_lowerbound, sigma_var_jp)
}

update_slipping_guessing <- function(slipping, guessing, ab_tilde) {
    invisible(.Call(`_slcm_update_slipping_guessing`, slipping, guessing, ab_tilde))
}

parm_update_nomiss <- function(N, J, K, nClass, M, Y, BETA, TAU, CLASS, pis, DELTA, omega, vv, main_effect_cols, CLtable, Atable, LBtable, Bindices, qtable, P, l1, m0, d0, a0, b0) {
    .Call(`_slcm_parm_update_nomiss`, N, J, K, nClass, M, Y, BETA, TAU, CLASS, pis, DELTA, omega, vv, main_effect_cols, CLtable, Atable, LBtable, Bindices, qtable, P, l1, m0, d0, a0, b0)
}

kappa_initialize <- function(M, J) {
    .Call(`_slcm_kappa_initialize`, M, J)
}

RLCMm2ll <- function(J, N, nClass, Y, theta, pis) {
    .Call(`_slcm_RLCMm2ll`, J, N, nClass, Y, theta, pis)
}

convert_to_q <- function(structure_matrix, betas) {
    .Call(`_slcm_convert_to_q`, structure_matrix, betas)
}

q_to_delta <- function(Q, Q_prime, M) {
    .Call(`_slcm_q_to_delta`, Q, Q_prime, M)
}

slcm_cpp <- function(Y, K, M, order, psi_invj, m0, bq, burnin = 1000L, chain_length = 10000L) {
    .Call(`_slcm_slcm_cpp`, Y, K, M, order, psi_invj, m0, bq, burnin, chain_length)
}

