% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-classify_coverage.R
\name{lqas_classify_}
\alias{lqas_classify_}
\alias{lqas_classify}
\alias{lqas_classify_cf}
\alias{lqas_classify_tc}
\title{LQAS classifier}
\usage{
lqas_classify_(
  cases_in,
  cases_out,
  rec_in = NULL,
  k = 3,
  threshold = c(0.2, 0.5),
  label = FALSE
)

lqas_classify(
  cases_in,
  cases_out,
  rec_in = NULL,
  k = 3,
  threshold = c(0.2, 0.5),
  label = FALSE
)

lqas_classify_cf(cases_in, cases_out, threshold = c(0.2, 0.5), label = FALSE)

lqas_classify_tc(
  cases_in,
  cases_out,
  rec_in,
  k,
  threshold = c(0.2, 0.5),
  label = FALSE
)
}
\arguments{
\item{cases_in}{Number of SAM and/or MAM cases found during the survey who
are in the CMAM programme.}

\item{cases_out}{Number of SAM and/or MAM cases found during the survey who
are in the CMAM programme.}

\item{rec_in}{Number of children recovering from SAM or MAM found during the
survey who are in the programme.}

\item{k}{Correction factor. Ratio of the mean length of an untreated episode
to the mean length of a CMAM treatment episode}

\item{threshold}{Decision rule threshold/s. Should be between 0 and 1. At
least one threshold should be provided for a two-tier classifier. Two
thresholds should be provided for a three-tier classifier. Default is a
three-tier classifier with rule set at 0.2 and 0.5.}

\item{label}{Logical. Should the output results be classification labels?
If TRUE, output classification are character labels else they are integer
values. Default is FALSE.}
}
\value{
A \code{\link[=data.frame]{data.frame()}} of coverage classifications for case-finding
effectiveness and for treatment coverage.
}
\description{
LQAS classifier
}
\examples{
lqas_classify(cases_in = 6, cases_out = 34, rec_in = 6)

with(
  survey_data,
  lqas_classify(
    cases_in = cases_in, cases_out = cases_out, rec_in = rec_in
  )
)

}
\author{
Ernest Guevarra
}
