% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_lm_hv.R
\name{cf_lm_hv}
\alias{cf_lm_hv}
\title{Holdout validation for coarse-to-fine training of spatial linear models}
\usage{
cf_lm_hv(
  y,
  x = NULL,
  coords,
  train_rat = 0.75,
  id_train = NULL,
  alpha = 0.9,
  kernel = "exp",
  add_learn = "none"
)
}
\arguments{
\item{y}{Vector of response variables (N x 1).}

\item{x}{Matrix of covariates (N x K).}

\item{coords}{Matrix of 2-dimensional point coordinates (N x 2).}

\item{train_rat}{Training sample ratio (default: 0.75). When N >= 1000,
training samples are randomly selected. Otherwise, samples closest to
the k-mean centers are used to stabilize the training.}

\item{id_train}{Optional. If specified, the corresponding samples are used
as training samples. Otherwise, training samples are selected at random
(default).}

\item{alpha}{Decay ratio of the kernel bandwidth in the coarse-to-fine
training (default: 0.9).}

\item{kernel}{Kernel type for modeling spatial dependence.
`"exp"` for the exponential kernel (default) and `"gau"` for the Gaussian kernel.}

\item{add_learn}{If `"rf"`, random forest is additionally trained to capture
non-linear patterns and/or higher-order interactions.
Default is `"none"`, meaning no additional training.}
}
\value{
A list with the following elements:
\describe{
  \item{sse_hv}{Sum-of-squared error (SSE) for validation samples.}
  \item{sse_hv_all}{All the SSEs obtained in each learning step.}
  \item{id_train}{ID of training samples.}
  \item{other}{List of other outcomes, which are internally used.}
}
}
\description{
Trains a coarse-to-fine spatial linear model and optimizes the spatial scale
(resolution) through progressive holdout validation.
}
\references{
Murakami, D., Comber, A., Yoshida, T., Tsutsumida, N., Brunsdon, C.,
& Nakaya, T. (2025).
Coarse-to-fine spatial modeling: A scalable, machine-learning-compatible
spatial model.
*arXiv:2510.00968*.
}
\seealso{
\code{\link{cf_lm}}
}
\author{
Daisuke Murakami
}
