# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title c++ quartic kernel
#' @name quartic_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
quartic_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_quartic_kernel_cpp`, d, bw)
}

#' @title c++ quartic kernel for one distance
#' @name quartic_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
quartic_kernelos <- function(d, bw) {
    .Call(`_spNetwork_quartic_kernelos`, d, bw)
}

#' @title c++ triangle kernel
#' @name triangle_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triangle_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_triangle_kernel_cpp`, d, bw)
}

#' @title c++ triangle kernel for one distance
#' @name triangle_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triangle_kernelos <- function(d, bw) {
    .Call(`_spNetwork_triangle_kernelos`, d, bw)
}

#' @title c++ uniform kernel
#' @name uniform_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
uniform_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_uniform_kernel_cpp`, d, bw)
}

#' @title c++ uniform kernel for one distance
#' @name uniform_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
uniform_kernelos <- function(d, bw) {
    .Call(`_spNetwork_uniform_kernelos`, d, bw)
}

#' @title c++ epanechnikov kernel
#' @name epanechnikov_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
epanechnikov_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_epanechnikov_kernel_cpp`, d, bw)
}

#' @title c++ epanechnikov kernel for one distance
#' @name epanechnikov_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
epanechnikov_kernelos <- function(d, bw) {
    .Call(`_spNetwork_epanechnikov_kernelos`, d, bw)
}

#' @title c++ triweight kernel
#' @name triweight_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triweight_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_triweight_kernel_cpp`, d, bw)
}

#' @title c++ triweight kernel for one distance
#' @name triweight_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triweight_kernelos <- function(d, bw) {
    .Call(`_spNetwork_triweight_kernelos`, d, bw)
}

#' @title c++ tricube kernel
#' @name tricube_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
tricube_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_tricube_kernel_cpp`, d, bw)
}

#' @title c++ tricube kernel for one distance
#' @name tricube_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
tricube_kernelos <- function(d, bw) {
    .Call(`_spNetwork_tricube_kernelos`, d, bw)
}

#' @title c++ cosine kernel
#' @name cosine_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
cosine_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_cosine_kernel_cpp`, d, bw)
}

#' @title c++ cosine kernel for one distance
#' @name cosine_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
cosine_kernelos <- function(d, bw) {
    .Call(`_spNetwork_cosine_kernelos`, d, bw)
}

#' @title c++ gaussian kernel
#' @name gaussian_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernel_cpp <- function(d, bw) {
    .Call(`_spNetwork_gaussian_kernel_cpp`, d, bw)
}

#' @title c++ gaussian kernel for one distance
#' @name gaussian_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernelos <- function(d, bw) {
    .Call(`_spNetwork_gaussian_kernelos`, d, bw)
}

#' @title c++ scale gaussian kernel
#' @name gaussian_kernel_scaled_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernel_scaled_cpp <- function(d, bw) {
    .Call(`_spNetwork_gaussian_kernel_scaled_cpp`, d, bw)
}

#' @title c++ scaled gaussian kernel for one distance
#' @name gaussian_kernel_scaledos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernel_scaledos <- function(d, bw) {
    .Call(`_spNetwork_gaussian_kernel_scaledos`, d, bw)
}

#' @title c++ quartic kernel integral
#' @name quartic_kernel_cpp
#' @param d_start a vector of start distances for which the density must be calculated
#' @param d_end a vector of end distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
quartic_kernel_int_cpp <- function(d_start, d_end, bw) {
    .Call(`_spNetwork_quartic_kernel_int_cpp`, d_start, d_end, bw)
}

#' @title A function to calculate the necessary information to apply the
#' Diggle correction factor with a discontinuous method (sparse)
#' @name corrfactor_discontinuous_sparse
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_discontinuous_sparse <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call(`_spNetwork_corrfactor_discontinuous_sparse`, neighbour_list, events, line_list, bws, max_depth)
}

#' @title A function to calculate the necessary informations to apply the
#' Diggle correction factor with a discontinuous method
#' @name corrfactor_discontinuous
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_discontinuous <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call(`_spNetwork_corrfactor_discontinuous`, neighbour_list, events, line_list, bws, max_depth)
}

#' @title A function to calculate the necessary information to apply the
#' Diggle correction factor with a continuous method (sparse)
#' @name corrfactor_continuous_sparse
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_continuous_sparse <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call(`_spNetwork_corrfactor_continuous_sparse`, neighbour_list, events, line_list, bws, max_depth)
}

#' @title A function to calculate the necessary information to apply the
#' Diggle correction factor with a continuous method
#' @name corrfactor_continuous
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_continuous <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call(`_spNetwork_corrfactor_continuous`, neighbour_list, events, line_list, bws, max_depth)
}

#' @title The worker function to calculate simple NKDE likelihood cv
#' @name ess_kernel_loo_nkde
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a matrix with the impact of the event v on each other events for
#' each pair of bandwidths (mat(event, bws_net))
#' @keywords internal
NULL

#' @title The worker function to calculate discontinuous TNKDE likelihood cv
#' @name esd_kernel_loo_nkde
#' @description The worker function to calculate discontinuous TNKDE likelihood cv (INTERNAL)
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other events for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
NULL

#' @title The worker function to calculate continuous TNKDE likelihood cv
#' @name esc_kernel_loo_nkde
#' @description The worker function to calculate continuous TNKDE likelihood cv (INTERNAL)
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other events for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
NULL

#' @title The exposed function to calculate NKDE likelihood cv
#' @name nkde_get_loo_values
#' @description The exposed function to calculate NKDE likelihood cv (INTERNAL)
#' @param method a string, one of "simple", "continuous", "discontinuous"
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param sel_events a Numeric vector indicating the selected events (id of nodes)
#' @param sel_events_wid a Numeric Vector indicating the unique if of the selected events
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param events_wid a NumericVector indicating the unique id of all the events
#' @param weights a matrix with the weights associated with each event (row) for each
#' bws_net (cols).
#' @param bws_net an arma::mat with the network bandwidths to consider for each event
#' @param kernel_name a string with the name of the kernel to use
#' @param line_list a DataFrame describing the lines
#' @param max_depth the maximum recursion depth
#' @param cvl a boolean indicating if the Cronie (TRUE) or CV likelihood (FALSE) must be used
#' @return a vector with the CV score for each bandwidth and the densities if required
#' @export
#' @examples
#' # no example provided, this is an internal function
nkde_get_loo_values <- function(method, neighbour_list, sel_events, sel_events_wid, events, events_wid, weights, bws_net, kernel_name, line_list, max_depth, cvl) {
    .Call(`_spNetwork_nkde_get_loo_values`, method, neighbour_list, sel_events, sel_events_wid, events, events_wid, weights, bws_net, kernel_name, line_list, max_depth, cvl)
}

#' @title The worker function to calculate simple TNKDE likelihood cv
#' @name ess_kernel_loo_tnkde
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param time_events a NumericVector indicating the timestamp of each event
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param v_time the time of v (double)
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param bws_time an arma::vec with the time bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other event for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
#' @keywords internal
NULL

#' @title The worker function to calculate simple TNKDE likelihood cv (adaptive case)
#' @name ess_kernel_loo_tnkde_adpt
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param time_events a NumericVector indicating the timestamp of each event
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param v_time the time of v (double)
#' @param bws_net an arma::mat with the network bandwidths to consider
#' @param bws_time an arma::mat with the time bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other event for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
#' @keywords internal
NULL

#' @title The worker function to calculate discontinuous TNKDE likelihood cv
#' @name esd_kernel_loo_tnkde
#' @description The worker function to calculate discontinuous TNKDE likelihood cv (INTERNAL)
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param time_events a NumericVector indicating the timestamp of each event
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param v_time the time of v (double)
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param bws_time an arma::vec with the time bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other event for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
NULL

#' @title The worker function to calculate discontinuous TNKDE likelihood cv (adaptive case)
#' @name esd_kernel_loo_tnkde_adpt
#' @description The worker function to calculate discontinuous TNKDE likelihood cv (INTERNAL)
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param time_events a NumericVector indicating the timestamp of each event
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param v_time the time of v (double)
#' @param bws_net an arma::mat with the network bandwidths to consider
#' @param bws_time an arma::mat with the time bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other event for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
#' @keywords internal
NULL

#' @title The worker function to calculate continuous TNKDE likelihood cv
#' @name esc_kernel_loo_tnkde
#' @description The worker function to calculate continuous TNKDE likelihood cv (INTERNAL)
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param time_events a NumericVector indicating the timestamp of each event
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param v_time the time of v (double)
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param bws_time an arma::vec with the time bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other event for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
NULL

#' @title The worker function to calculate continuous TNKDE likelihood cv (adaptive case)
#' @name esc_kernel_loo_tnkde_adpt
#' @description The worker function to calculate continuous TNKDE likelihood cv (INTERNAL)
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param time_events a NumericVector indicating the timestamp of each event
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider (int)
#' @param v_time the time of v (double)
#' @param bws_net an arma::mat with the network bandwidths to consider
#' @param bws_time an arma::mat with the time bandwidths to consider
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a cube with the impact of the event v on each other event for
#' each pair of bandwidths (cube(bws_net, bws_time, events))
#' @keywords internal
NULL

#' @title The exposed function to calculate TNKDE likelihood cv
#' @name tnkde_get_loo_values
#' @description The exposed function to calculate TNKDE likelihood cv (INTERNAL)
#' @param method a string, one of "simple", "continuous", "discontinuous"
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param sel_events a Numeric vector indicating the selected events (id of nodes)
#' @param sel_events_wid a Numeric Vector indicating the unique if of the selected events
#' @param sel_events_time a Numeric Vector indicating the time of the selected events
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param events_wid a NumericVector indicating the unique id of all the events
#' @param events_time a NumericVector indicating the timestamp of each event
#' @param weights a cube with the weights associated with each event for each
#' bws_net and bws_time.
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param bws_time an arma::vec with the time bandwidths to consider
#' @param kernel_name a string with the name of the kernel to use
#' @param line_list a DataFrame describing the lines
#' @param max_depth the maximum recursion depth
#' @param min_tol a double indicating by how much 0 in density values must be replaced
#' @return a matrix with the CV score for each pair of bandiwdths
#' @export
#' @examples
#' # no example provided, this is an internal function
tnkde_get_loo_values <- function(method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol) {
    .Call(`_spNetwork_tnkde_get_loo_values`, method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol)
}

#' @title The exposed function to calculate TNKDE likelihood cv
#' @name tnkde_get_loo_values2
#' @description The exposed function to calculate TNKDE likelihood cv (INTERNAL) when an adaptive bandwidth is used
#' @param method a string, one of "simple", "continuous", "discontinuous"
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param sel_events a Numeric vector indicating the selected events (id of nodes)
#' @param sel_events_wid a Numeric Vector indicating the unique if of the selected events
#' @param sel_events_time a Numeric Vector indicating the time of the selected events
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param events_wid a NumericVector indicating the unique id of all the events
#' @param events_time a NumericVector indicating the timestamp of each event
#' @param weights a cube with the weights associated with each event for each
#' bws_net and bws_time.
#' @param bws_net an arma::cube of three dimensions with the network bandwidths calculated for each observation for each global time and network bandwidths
#' @param bws_time an arma::cube of three dimensions with the time bandwidths calculated for each observation for each global time and network bandwidths
#' @param kernel_name a string with the name of the kernel to use
#' @param line_list a DataFrame describing the lines
#' @param max_depth the maximum recursion depth
#' @param min_tol a double indicating by how much 0 in density values must be replaced
#' @return a matrix with the CV score for each pair of global bandiwdths
#' @export
#' @examples
#' # no example provided, this is an internal function
tnkde_get_loo_values2 <- function(method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol) {
    .Call(`_spNetwork_tnkde_get_loo_values2`, method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol)
}

#' @title The exposed function to calculate adaptive bandwidth with space-time
#' interaction for TNKDE (INTERNAL)
#' @name adaptive_bw_tnkde_cpp
#' @param method a string, one of "simple", "continuous", "discontinuous"
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param sel_events a Numeric vector indicating the selected events (id of nodes)
#' @param sel_events_wid a Numeric Vector indicating the unique if of the selected events
#' @param sel_events_time a Numeric Vector indicating the time of the selected events
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param events_wid a NumericVector indicating the unique id of all the events
#' @param events_time a NumericVector indicating the timestamp of each event
#' @param weights a cube with the weights associated with each event for each
#' bws_net and bws_time.
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param bws_time an arma::vec with the time bandwidths to consider
#' @param kernel_name a string with the name of the kernel to use
#' @param line_list a DataFrame describing the lines
#' @param max_depth the maximum recursion depth
#' @param min_tol a double indicating by how much 0 in density values must be replaced
#' @return a vector witht the estimated density at each event location
#' @export
#' @examples
#' # no example provided, this is an internal function
adaptive_bw_tnkde_cpp <- function(method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol) {
    .Call(`_spNetwork_adaptive_bw_tnkde_cpp`, method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol)
}

#' @title The exposed function to calculate adaptive bandwidth with space-time
#' interaction for TNKDE (INTERNAL)
#' @name adaptive_bw_tnkde_cpp2
#' @param method a string, one of "simple", "continuous", "discontinuous"
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param sel_events a Numeric vector indicating the selected events (id of nodes)
#' @param sel_events_wid a Numeric Vector indicating the unique if of the selected events
#' @param sel_events_time a Numeric Vector indicating the time of the selected events
#' @param events a NumericVector indicating the nodes in the graph being events
#' @param events_wid a NumericVector indicating the unique id of all the events
#' @param events_time a NumericVector indicating the timestamp of each event
#' @param weights a cube with the weights associated with each event for each
#' bws_net and bws_time.
#' @param bws_net an arma::vec with the network bandwidths to consider
#' @param bws_time an arma::vec with the time bandwidths to consider
#' @param kernel_name a string with the name of the kernel to use
#' @param line_list a DataFrame describing the lines
#' @param max_depth the maximum recursion depth
#' @param min_tol a double indicating by how much 0 in density values must be replaced
#' @return a vector with the estimated density at each event location
#' @export
#' @examples
#' # no example provided, this is an internal function
adaptive_bw_tnkde_cpp2 <- function(method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol) {
    .Call(`_spNetwork_adaptive_bw_tnkde_cpp2`, method, neighbour_list, sel_events, sel_events_wid, sel_events_time, events, events_wid, events_time, weights, bws_net, bws_time, kernel_name, line_list, max_depth, min_tol)
}

find_nearest_object_in_line_rtree <- function(pts, lines, min_dist, max_iter) {
    .Call(`_spNetwork_find_nearest_object_in_line_rtree`, pts, lines, min_dist, max_iter)
}

calc_line_length <- function(line) {
    .Call(`_spNetwork_calc_line_length`, line)
}

cut_line_at_dist <- function(line, d) {
    .Call(`_spNetwork_cut_line_at_dist`, line, d)
}

cut_lines_at_distances_cpp <- function(lines, dists) {
    .Call(`_spNetwork_cut_lines_at_distances_cpp`, lines, dists)
}

trim_line_for_isos <- function(line, start_dist, end_dist, donught, d, dd) {
    .Call(`_spNetwork_trim_line_for_isos`, line, start_dist, end_dist, donught, d, dd)
}

trim_lines_for_isos_cpp <- function(lines, start_dists, end_dists, donught, d, dd) {
    .Call(`_spNetwork_trim_lines_for_isos_cpp`, lines, start_dists, end_dists, donught, d, dd)
}

add_vertices_lines_cpp <- function(points, lines, nearest_lines_idx, mindist) {
    .Call(`_spNetwork_add_vertices_lines_cpp`, points, lines, nearest_lines_idx, mindist)
}

add_center_lines_cpp <- function(lines) {
    .Call(`_spNetwork_add_center_lines_cpp`, lines)
}

split_lines_at_points_cpp <- function(Xmat, lines, nearest_lines_idx, mindist) {
    .Call(`_spNetwork_split_lines_at_points_cpp`, Xmat, lines, nearest_lines_idx, mindist)
}

lixelize_lines_cpp <- function(lines, lx_length, mindist) {
    .Call(`_spNetwork_lixelize_lines_cpp`, lines, lx_length, mindist)
}

points_along_lines_cpp <- function(lines, dist) {
    .Call(`_spNetwork_points_along_lines_cpp`, lines, dist)
}

points_at_lines_centers_cpp <- function(lines) {
    .Call(`_spNetwork_points_at_lines_centers_cpp`, lines)
}

#' @title c++ k function
#' @name kfunc_cpp
#' @description c++ k function (INTERNAL)
#' @param dist_mat A square matrix with the distances between points
#' @param start A float, the start value for evaluating the k-function
#' @param end A float, the last value for evaluating the k-function
#' @param step A float, the jump between two evaluations of the k-function
#' @param Lt The total length of the network
#' @param n The number of points
#' @param w The weight of the points (coincident points)
#' @return A numeric vector with the values of the k function evaluated at the required distances
#' @export
kfunc_cpp <- function(dist_mat, start, end, step, Lt, n, w) {
    .Call(`_spNetwork_kfunc_cpp`, dist_mat, start, end, step, Lt, n, w)
}

#' @title c++ k function counting worker
#' @name kfunc_counting
#' @description c++ k function counting (INTERNAL)
#' @param dist_mat A matrix with the distances between points
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @param breaks A numeric vector with the distance to consider
#' @param cross A boolean indicating if we are calculating a cross k function or not (default is FALSE)
#' @return A numeric matrix with the countings of the k function evaluated at the required distances
#' @keywords internal
#' @export
kfunc_counting <- function(dist_mat, wc, wr, breaks, cross = FALSE) {
    .Call(`_spNetwork_kfunc_counting`, dist_mat, wc, wr, breaks, cross)
}

#' @title c++ k function 2
#' @name kfunc_cpp2
#' @description c++ k function (INTERNAL)
#' @param dist_mat A square matrix with the distances between points
#' @param start A float, the start value for evaluating the k-function
#' @param end A float, the last value for evaluating the k-function
#' @param step A float, the jump between two evaluations of the k-function
#' @param Lt The total length of the network
#' @param n The number of points
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @param cross A boolean indicating if we are calculating a cross k function or not (default is FALSE)
#' @return A numeric vector with the values of the k function evaluated at the required distances
#' @keywords internal
#' @export
kfunc_cpp2 <- function(dist_mat, start, end, step, Lt, n, wc, wr, cross = FALSE) {
    .Call(`_spNetwork_kfunc_cpp2`, dist_mat, start, end, step, Lt, n, wc, wr, cross)
}

#' @title c++ g function counting worker
#' @name gfunc_counting
#' @description c++ k function counting (INTERNAL)
#' @param dist_mat A matrix with the distances between points
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @param breaks A numeric vector with the distance to consider
#' @param width The width of each donut
#' @return A numeric matrix with the countings of the g function evaluated at the required distances
#' @keywords internal
#' @export
gfunc_counting <- function(dist_mat, wc, wr, breaks, width) {
    .Call(`_spNetwork_gfunc_counting`, dist_mat, wc, wr, breaks, width)
}

#' @title c++ g function
#' @name gfunc_cpp2
#' @description c++ g function (INTERNAL)
#' @param dist_mat A square matrix with the distances between points
#' @param start A float, the start value for evaluating the g-function
#' @param end A float, the last value for evaluating the g-function
#' @param step A float, the jump between two evaluations of the k-function
#' @param width The width of each donut
#' @param Lt The total length of the network
#' @param n The number of points
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @return A numeric vector with the values of the g function evaluated at the required distances
#' @keywords internal
#' @export
gfunc_cpp2 <- function(dist_mat, start, end, step, width, Lt, n, wc, wr) {
    .Call(`_spNetwork_gfunc_cpp2`, dist_mat, start, end, step, width, Lt, n, wc, wr)
}

#' @title c++ k and g function counting worker
#' @name kgfunc_counting
#' @description c++ k function counting (INTERNAL)
#' @param dist_mat A matrix with the distances between points
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @param breaks A numeric vector with the distance to consider
#' @param width The width of each donut
#' @param cross A boolean indicating if we are calculating a cross k function or not (default is FALSE)
#' @return A list  of two numeric matrices with the values of the k and g function evaluated at the required distances
#' @keywords internal
#' @export
kgfunc_counting <- function(dist_mat, wc, wr, breaks, width, cross = FALSE) {
    .Call(`_spNetwork_kgfunc_counting`, dist_mat, wc, wr, breaks, width, cross)
}

#' @title c++ k and g function
#' @name kgfunc_cpp2
#' @description c++ g function (INTERNAL)
#' @param dist_mat A square matrix with the distances between points
#' @param start A float, the start value for evaluating the g-function
#' @param end A float, the last value for evaluating the g-function
#' @param step A float, the jump between two evaluations of the k-function
#' @param width The width of each donut
#' @param Lt The total length of the network
#' @param n The number of points
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @param cross A boolean indicating if we are calculating a cross k function or not (default is FALSE)
#' @return A numeric matrix with the values of the k (first col) and g (second col) function evaluated at the required distances
#' @keywords internal
#' @export
kgfunc_cpp2 <- function(dist_mat, start, end, step, width, Lt, n, wc, wr, cross = FALSE) {
    .Call(`_spNetwork_kgfunc_cpp2`, dist_mat, start, end, step, width, Lt, n, wc, wr, cross)
}

#' @title c++ g function
#' @name gfunc_cpp
#' @description c++ g function (INTERNAL)
#' @param dist_mat A square matrix with the distances between points
#' @param start A float, the start value for evaluating the g-function
#' @param end A float, the last value for evaluating the g-function
#' @param step A float, the jump between two evaluations of the k-function
#' @param width The width of each donut
#' @param Lt The total length of the network
#' @param n The number of points
#' @param w The weight of the points (coincident points)
#' @return A numeric vector with the values of the g function evaluated at the required distances
#' @export
gfunc_cpp <- function(dist_mat, start, end, step, width, Lt, n, w) {
    .Call(`_spNetwork_gfunc_cpp`, dist_mat, start, end, step, width, Lt, n, w)
}

#' @title c++ cross k function
#' @name cross_kfunc_cpp
#' @param dist_mat A square matrix with the distances between points
#' @param start A float, the start value for evaluating the k-function
#' @param end A float, the last value for evaluating the k-function
#' @param step A float, the jump between two evaluations of the k-function
#' @param Lt The total length of the network
#' @param na The number of points in set A
#' @param nb The number of points in set B
#' @param wa The weight of the points in set A (coincident points)
#' @param wb The weight of the points in set B (coincident points)
cross_kfunc_cpp <- function(dist_mat, start, end, step, Lt, na, nb, wa, wb) {
    .Call(`_spNetwork_cross_kfunc_cpp`, dist_mat, start, end, step, Lt, na, nb, wa, wb)
}

#' @title c++ cross g function
#' @name cross_gfunc_cpp
#' @description c++ cross g function (INTERNAL)
#' @param dist_mat A matrix with the distances between points
#' @param start A float, the start value for evaluating the g-function
#' @param end A float, the last value for evaluating the g-function
#' @param step A float, the jump between two evaluations of the k-function
#' @param width The width of each donut
#' @param Lt The total length of the network
#' @param na The number of points in set A
#' @param nb The number of points in set B
#' @param wa The weight of the points in set A (coincident points)
#' @param wb The weight of the points in set B (coincident points)
cross_gfunc_cpp <- function(dist_mat, start, end, step, width, Lt, na, nb, wa, wb) {
    .Call(`_spNetwork_cross_gfunc_cpp`, dist_mat, start, end, step, width, Lt, na, nb, wa, wb)
}

#' @title c++ k space-time function
#' @name k_nt_func_cpp
#' @param dist_mat_net A square matrix with the distances between points (network)
#' @param dist_mat_time A square matrix with the distances between points (time)
#' @param start_net A float, the start value for evaluating the k-function (network)
#' @param end_net A float, the last value for evaluating the k-function (network)
#' @param step_net A float, the jump between two evaluations of the k-function (network)
#' @param start_time A float, the start value for evaluating the k-function (time)
#' @param end_time A float, the last value for evaluating the k-function (time)
#' @param step_time A float, the jump between two evaluations of the k-function (time)
#' @param Lt The total length of the network
#' @param Tt The total duration of study area
#' @param n The number of points
#' @param w The weight of the points (coincident points)
#' @keywords internal
k_nt_func_cpp <- function(dist_mat_net, dist_mat_time, start_net, end_net, step_net, start_time, end_time, step_time, Lt, Tt, n, w) {
    .Call(`_spNetwork_k_nt_func_cpp`, dist_mat_net, dist_mat_time, start_net, end_net, step_net, start_time, end_time, step_time, Lt, Tt, n, w)
}

#' @title c++ g space-time function
#' @name g_nt_func_cpp
#' @param dist_mat_net A square matrix with the distances between points on the network
#' @param dist_mat_time A square matrix with the distances between points in time
#' @param start_net A float, the start value for evaluating the g-function on the network
#' @param end_net A float, the last value for evaluating the g-function on the network
#' @param step_net A float, the jump between two evaluations of the g-function on the network
#' @param width_net The width of each donut on the network
#' @param start_time A float, the start value for evaluating the g-function in time
#' @param end_time A float, the last value for evaluating the g-function in time
#' @param step_time A float, the jump between two evaluations of the g-function in time
#' @param width_time The width of each donut in time
#' @param Lt The total length of the network
#' @param n The number of points
#' @param w The weight of the points (coincident points)
#' @keywords internal
g_nt_func_cpp <- function(dist_mat_net, dist_mat_time, start_net, end_net, step_net, width_net, start_time, end_time, step_time, width_time, Lt, Tt, n, w) {
    .Call(`_spNetwork_g_nt_func_cpp`, dist_mat_net, dist_mat_time, start_net, end_net, step_net, width_net, start_time, end_time, step_time, width_time, Lt, Tt, n, w)
}

#' @title c++ k and g function counting worker
#' @name kgfunc_time_counting
#' @description c++ k function counting (INTERNAL)
#' @param dist_mat_net A matrix with the distances between points on the network
#' @param dist_mat_time A matrix with the distances between points in time
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @param breaks_net A numeric vector with the distance to consider on network
#' @param breaks_time A numeric vector with the distance to consider in time
#' @param width_net The width of each donut for the network dimension
#' @param width_time The width of each donut for the time dimension
#' @param cross A boolean indicating if we are calculating a cross k function or not (default is FALSE)
#' @return A list  of two numeric cubes with the values of the k and g function evaluated at the required distances
#' @keywords internal
#' @export
kgfunc_time_counting <- function(dist_mat_net, dist_mat_time, wc, wr, breaks_net, breaks_time, width_net, width_time, cross = FALSE) {
    .Call(`_spNetwork_kgfunc_time_counting`, dist_mat_net, dist_mat_time, wc, wr, breaks_net, breaks_time, width_net, width_time, cross)
}

#' @title c++ k function counting worker
#' @name kgfunc_time_counting
#' @description c++ k function counting (INTERNAL)
#' @param dist_mat_net A matrix with the distances between points on the network
#' @param dist_mat_time A matrix with the distances between points in time
#' @param wc The weight of the points represented by the columns (destinations)
#' @param wr The weight of the points represented by the rows (origins)
#' @param breaks_net A numeric vector with the distance to consider on network
#' @param breaks_time A numeric vector with the distance to consider in time
#' @param cross A boolean indicating if we are calculating a cross k function or not (default is FALSE)
#' @return A list  of two numeric cubes with the values of the k and g function evaluated at the required distances
#' @export
kfunc_time_counting <- function(dist_mat_net, dist_mat_time, wc, wr, breaks_net, breaks_time, cross = FALSE) {
    .Call(`_spNetwork_kfunc_time_counting`, dist_mat_net, dist_mat_time, wc, wr, breaks_net, breaks_time, cross)
}

#' @title c++ k and g space-time function
#' @name k_nt_func_cpp
#' @param dist_mat_net A square matrix with the distances between points (network)
#' @param dist_mat_time A square matrix with the distances between points (time)
#' @param start_net A float, the start value for evaluating the k-function (network)
#' @param end_net A float, the last value for evaluating the k-function (network)
#' @param step_net A float, the jump between two evaluations of the k-function (network)
#' @param width_net A float indicating the width of the donught of the g-function (network)
#' @param start_time A float, the start value for evaluating the k-function (time)
#' @param end_time A float, the last value for evaluating the k-function (time)
#' @param step_time A float, the jump between two evaluations of the k-function (time)
#' @param width_time A float indicating the width of the donught of the g-function (time)
#' @param Lt The total length of the network
#' @param Tt The total duration of study area
#' @param n The number of points
#' @param w The weight of the points (coincident points)
#' @param cross a boolean indicating of we are calculating a cross k or g function
#' @keywords internal
k_g_nt_func_cpp2 <- function(dist_mat_net, dist_mat_time, start_net, end_net, step_net, start_time, end_time, step_time, width_net, width_time, Lt, Tt, n, wc, wr, cross = FALSE) {
    .Call(`_spNetwork_k_g_nt_func_cpp2`, dist_mat_net, dist_mat_time, start_net, end_net, step_net, start_time, end_time, step_time, width_net, width_time, Lt, Tt, n, wc, wr, cross)
}

#' @title c++ k space-time function
#' @name k_nt_func_cpp
#' @param dist_mat_net A square matrix with the distances between points (network)
#' @param dist_mat_time A square matrix with the distances between points (time)
#' @param start_net A float, the start value for evaluating the k-function (network)
#' @param end_net A float, the last value for evaluating the k-function (network)
#' @param step_net A float, the jump between two evaluations of the k-function (network)
#' @param start_time A float, the start value for evaluating the k-function (time)
#' @param end_time A float, the last value for evaluating the k-function (time)
#' @param step_time A float, the jump between two evaluations of the k-function (time)
#' @param Lt The total length of the network
#' @param Tt The total duration of study area
#' @param n The number of points
#' @param w The weight of the points (coincident points)
#' @param cross a boolean indicating of we are calculating a cross k or g function
#' @keywords internal
k_nt_func_cpp2 <- function(dist_mat_net, dist_mat_time, start_net, end_net, step_net, start_time, end_time, step_time, Lt, Tt, n, wc, wr, cross = FALSE) {
    .Call(`_spNetwork_k_nt_func_cpp2`, dist_mat_net, dist_mat_time, start_net, end_net, step_net, start_time, end_time, step_time, Lt, Tt, n, wc, wr, cross)
}

seq_num2 <- function(start, end, step) {
    .Call(`_spNetwork_seq_num2`, start, end, step)
}

seq_num3 <- function(start, end, step) {
    .Call(`_spNetwork_seq_num3`, start, end, step)
}

seq_num2f <- function(start, end, step) {
    .Call(`_spNetwork_seq_num2f`, start, end, step)
}

extend_matrix_by_ids <- function(agg_mat, oids, locids) {
    .Call(`_spNetwork_extend_matrix_by_ids`, agg_mat, oids, locids)
}

reverseByRow <- function(inmat) {
    .Call(`_spNetwork_reverseByRow`, inmat)
}

#' @title euclidean distance between rows of a matrix and a vector (arma mode)
#' @name calcEuclideanDistance3
#' @param y a matrix
#' @param x a vector (same length as ncol(matrix))
#' @return a vector (same length as nrow(matrix))
#' @export
#' @keywords internal
#'
calcEuclideanDistance3 <- function(y, x) {
    .Call(`_spNetwork_calcEuclideanDistance3`, y, x)
}

#' @title pairwise distance between two vectors
#' @name pair_dists
#' @param x a numeric vector
#' @param y a numeric vector
#' @return a matrix width dimenion l(x) * l(y)
#' @export
#' @keywords internal
#'
pair_dists <- function(x, y) {
    .Call(`_spNetwork_pair_dists`, x, y)
}

#' @title The worker function to calculate continuous NKDE (with ARMADILLO and sparse matrix)
#' @name continuousWorker_sparse
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param samples_k a numeric vector of the actual kernel values, updates at
#' each recursion
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandwidth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_coords a matrix with the X and Y coordinates of the samples
#' @param nodes_coords a matrix with the X and Y coordinates of the nodes
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The worker function to calculate continuous NKDE (with ARMADILLO and integer matrix)
#' @name continuousWorker
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param samples_k a numeric vector of the actual kernel values, updates at
#' each recursion
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandwidth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_x a vector with x coordinates of each sample
#' @param samples_y a vector with y coordinates of each sample
#' @param nodes_x a vector with x coordinates of each node
#' @param nodes_y a vector with y coordinates of each node
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The main function to calculate continuous NKDE (with ARMADILO and sparse matrix)
#' @name continuousfunction2
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidths for each event
#' @param kernel_name the name of the kernel to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div The divisor to use for the kernel. Must be "n" (the number of events within the radius around each sampling point), "bw" (the bandwidth) "none" (the simple sum).
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
#'
continuous_nkde_cpp_arma_sparse <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div = "bw") {
    .Call(`_spNetwork_continuous_nkde_cpp_arma_sparse`, neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div)
}

#' @title The main function to calculate continuous NKDE (with ARMADILO and integer matrix)
#' @name continuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidths for each event
#' @param kernel_name the name of the kernel to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div The divisor to use for the kernel. Must be "n" (the number of events within the radius around each sampling point), "bw" (the bandwidth) "none" (the simple sum).
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
#'
continuous_nkde_cpp_arma <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div = "bw") {
    .Call(`_spNetwork_continuous_nkde_cpp_arma`, neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div)
}

#' @title The main function to calculate continuous TNKDE (with ARMADILO and sparse matrix)
#' @name tnkdecontinuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param events_time a numeric vector with the time for the events
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param samples_time a NumericVector indicating when to do the samples
#' @param bws_net the network kernel bandwidths for each event
#' @param bws_time the time kernel bandwidths for each event
#' @param kernel_name the name of the kernel to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div a string indicating how to standardize the kernel values
#' @return a List with two matrices: the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
#'
continuous_tnkde_cpp_arma_sparse <- function(neighbour_list, events, events_time, weights, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div) {
    .Call(`_spNetwork_continuous_tnkde_cpp_arma_sparse`, neighbour_list, events, events_time, weights, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div)
}

#' @title The main function to calculate continuous TNKDE (with ARMADILO and integer matrix)
#' @name tnkdecontinuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param events_time a numeric vector with the time for the events
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param samples_time a NumericVector indicating when to do the samples
#' @param bws_net the network kernel bandwidths for each event
#' @param kernel_name the name of the kernel to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div a string indicating how to standardize the kernel values
#' @return a List with two matrices: the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
#'
continuous_tnkde_cpp_arma <- function(neighbour_list, events, events_time, weights, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div) {
    .Call(`_spNetwork_continuous_tnkde_cpp_arma`, neighbour_list, events, events_time, weights, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div)
}

#' @title The worker function to calculate discontinuous NKDE (with ARMADILLO and sparse matrix)
#' @name discontinuousWorker_sparse
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandiwdth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_coords a matrix with the X and Y coordinates of the samples
#' @param nodes_coords a matrix with the X and Y coordinates of the nodes
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The worker function to calculate discontinuous NKDE (with ARMADILLO and Integer matrix)
#' @name discontinuousWorker_int
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandiwdth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_x a vector with x coordinates of each sample
#' @param samples_ya vector with y coordinates of each sample
#' @param nodes_x a vector with x coordinates of each node
#' @param nodes_y a vector with y coordinates of each node
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The main function to calculate discontinuous NKDE (ARMA and sparse matrix)
#' @name discontinuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidths for each event
#' @param kernel_name the name of the kernel function to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div The divisor to use for the kernel. Must be "n" (the number of events within the radius around each sampling point), "bw" (the bandwidth) "none" (the simple sum).
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
discontinuous_nkde_cpp_arma_sparse <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div = "bw") {
    .Call(`_spNetwork_discontinuous_nkde_cpp_arma_sparse`, neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div)
}

#' @title The main function to calculate discontinuous NKDE (ARMA and Integer matrix)
#' @name discontinuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidth for each event
#' @param kernel_name the name of the kernel function to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div The divisor to use for the kernel. Must be "n" (the number of events within the radius around each sampling point), "bw" (the bandwidth) "none" (the simple sum).
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
discontinuous_nkde_cpp_arma <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div = "bw") {
    .Call(`_spNetwork_discontinuous_nkde_cpp_arma`, neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose, div)
}

#' @title The main function to calculate discontinuous NKDE (ARMA and sparse matrix)
#' @name tnkdediscontinuousfunctionsparse
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param events_time a numeric vector with the time for the events
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param samples_time a NumericVector indicating when to do the samples
#' @param bws_net the network kernel bandwidths for each event
#' @param kernel_name the name of the kernel function to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div a string indicating how to standardize the kernel values
#' @return a List with two matrices: the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
discontinuous_tnkde_cpp_arma_sparse <- function(neighbour_list, events, weights, events_time, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div = "bw") {
    .Call(`_spNetwork_discontinuous_tnkde_cpp_arma_sparse`, neighbour_list, events, weights, events_time, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div)
}

#' @title The main function to calculate discontinuous NKDE (ARMA and Integer matrix)
#' @name tnkdediscontinuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param events_time a numeric vector with the time for the events
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param samples_time a NumericVector indicating when to do the samples
#' @param bws_net the network kernel bandwidths for each event
#' @param kernel_name the name of the kernel function to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @param div a string indicating how to standardize the kernel values
#' @return a List with two matrices: the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
discontinuous_tnkde_cpp_arma <- function(neighbour_list, events, weights, events_time, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div = "bw") {
    .Call(`_spNetwork_discontinuous_tnkde_cpp_arma`, neighbour_list, events, weights, events_time, samples, samples_time, bws_net, bws_time, kernel_name, nodes, line_list, max_depth, verbose, div)
}

