% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_sf.R
\name{sanity_check_knn}
\alias{sanity_check_knn}
\title{Sanity check for the knn functions}
\usage{
sanity_check_knn(
  origins,
  destinations,
  lines,
  k,
  maxdistance,
  snap_dist,
  line_weight,
  direction,
  grid_shape,
  verbose,
  digits,
  tol
)
}
\arguments{
\item{origins}{A a feature collection of points, for each point, its k nearest
neighbours will be found on the network.}

\item{destinations}{A a feature collection of points, might be used if the neighbours
must be found in a separate dataset. NULL if the neighbours must be found in
origins.}

\item{lines}{A a feature collection of linestrings representing the network}

\item{k}{An integer indicating the number of neighbours to find..}

\item{maxdistance}{The maximum distance between two observations to
consider them as neighbours. It is useful only if a grid is used, a
lower value will reduce calculating time, but one must be sure that the
k nearest neighbours are within this radius. Otherwise NAs will be present
in the final matrices.}

\item{snap_dist}{The maximum distance to snap the start and end points on
the network.}

\item{line_weight}{The weighting to use for lines. Default is "length"
(the geographical length), but can be the name of a column. The value is
considered proportional to the geographical length of the lines.}

\item{direction}{Indicates a field providing information about authorized
travelling direction on lines. if NULL, then all lines can be used in both
directions. Must be the name of a column otherwise. The values of the
column must be "FT" (From - To), "TF" (To - From) or "Both".}

\item{grid_shape}{A vector of length 2 indicating the shape of the grid to
use for splitting the dataset. Default is c(1,1), so all the calculation is
done in one go. It might be necessary to split it if the dataset is large.}

\item{verbose}{A Boolean indicating if the function should print its
progress}

\item{digits}{The number of digits to retain in the spatial coordinates (
simplification used to reduce risk of topological error)}

\item{tol}{A float indicating the spatial tolerance when points are
added as vertices to lines.}
}
\value{
A list with two matrices, one with the index of the neighbours and
one with the distances.
}
\description{
Check if all the parameters are valid for the knn functions
}
\examples{
#no example provided, this is an internal function
}
\keyword{internal}
