% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{candidateModels}
\alias{candidateModels}
\title{Create a collection of candidate models for stacking}
\usage{
candidateModels(params_list, aggregation = "simple")
}
\arguments{
\item{params_list}{a list of candidate values for each model parameter. See
examples for details.}

\item{aggregation}{a character string specifying the type of aggregation to
be used. Options are \code{'simple'} and \code{'cartesian'}. Default is
\code{'simple'}.}
}
\value{
an object of class \code{'candidateModels'}
}
\description{
Creates an object of class \code{'candidateModels'} that
contains a list of candidate models for stacking. The function takes a list
of candidate values for each model parameter and returns a list of possible
combinations of these values based on either simple aggregation or Cartesian
product of indivdual candidate values.
}
\examples{
m1 <- candidateModels(list(phi_s = c(1, 1), phi_t = c(1, 2)), "simple")
m1
m2 <- candidateModels(list(phi_s = c(1, 1), phi_t = c(1, 2)), "cartesian")
m2
m3 <- candidateModels(list(phi_s = list(c(1, 1), c(1, 2)),
                          phi_t = list(c(1, 3), c(2, 3)),
                          boundary = c(0.5, 0.75)),
                      "simple")
}
\seealso{
\code{\link[=stvcGLMstack]{stvcGLMstack()}}
}
\author{
Soumyakanti Pan \href{mailto:span18@ucla.edu}{span18@ucla.edu},\cr
Sudipto Banerjee \href{mailto:sudipto@ucla.edu}{sudipto@ucla.edu}
}
