% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_ssao}
\alias{compute_ssao}
\title{Compute SSAO (Screen Space Ambient Occlusion) for point cloud}
\usage{
compute_ssao(
  las,
  kernel_size = 5,
  pixel_size = 0.1,
  num_samples = 16,
  ncpu = 4
)
}
\arguments{
\item{las}{LAS object}

\item{kernel_size}{Integer kernel size in pixels for sampling}

\item{pixel_size}{Numeric resolution of the depth map in spatial units}

\item{num_samples}{Integer number of samples per point}

\item{ncpu}{Integer number of CPUs to use for parallel processing}
}
\value{
Numeric vector of SSAO values (ambient occlusion) for each point
}
\description{
Fast ambient occlusion using 2D depth buffer technique.
Much faster than PCV as it works on projected depth maps.
}
\details{
The SSAO algorithm computes ambient occlusion by:
\itemize{
\item Projecting the point cloud to a 2D depth map (grid)
\item For each point, sampling the depth buffer around it
\item Calculating occlusion based on depth differences
\item Applying distance and angle-based falloff
}

This is significantly faster than full 3D PCV because it only requires
2D image processing operations rather than 3D neighbor searches and ray tracing.
}
\keyword{internal}
