% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{las2xyz}
\alias{las2xyz}
\title{Convert LAS object to XYZ matrix}
\usage{
las2xyz(las)
}
\arguments{
\item{las}{LAS object to convert}
}
\value{
A numeric matrix with three columns (X, Y, Z) containing the point coordinates
}
\description{
Extracts the X, Y, and Z coordinates from a LAS object and returns them as a matrix.
}
\examples{
\donttest{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)
xyz_matrix <- las2xyz(las)
head(xyz_matrix)
}
}
