% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{run_abrm}
\alias{run_abrm}
\title{Run ABRM Analysis}
\usage{
run_abrm(
  gridx,
  gridy,
  atoms,
  model_code,
  true_params = NULL,
  norm_idx_x = NULL,
  pois_idx_x = NULL,
  binom_idx_x = NULL,
  norm_idx_y = NULL,
  pois_idx_y = NULL,
  binom_idx_y = NULL,
  dist_y = 2,
  niter = 50000,
  nburnin = 30000,
  nchains = 2,
  thin = 10,
  seed = NULL,
  sim_metadata = NULL,
  save_plots = TRUE,
  output_dir = NULL
)
}
\arguments{
\item{gridx}{The X-grid sf dataframe, containing a numeric area ID variable named 'ID' and covariates named 'covariate_x_1','covariate_x_2',...}

\item{gridy}{The Y-grid sf dataframe, containing a numeric area ID variable named 'ID', covariates named 'covariate_y_1','covariate_y_2',...., and an outcome named 'y'.}

\item{atoms}{The atom sf dataframe, which should contain numeric variables named 'ID_x' and 'ID_y' holding the X-grid and Y-grid cell IDs for each atom, as well as an atom-level population count named 'population'.}

\item{model_code}{NIMBLE model code from get_abrm_model()}

\item{true_params}{The true outcome model regression coefficient parameters, if known (e.g., from simulate_misaligned_data())}

\item{norm_idx_x}{Vector of numeric indices of X-grid covariates (ordered as 'covariate_x_1','covariate_x_2',...) that should be treated as normally-distributed}

\item{pois_idx_x}{Vector of numeric indices of X-grid covariates (ordered as 'covariate_x_1','covariate_x_2',...) that should be treated as Poisson-distributed}

\item{binom_idx_x}{Vector of numeric indices of X-grid covariates (ordered as 'covariate_x_1','covariate_x_2',...) that should be treated as binomial-distributed}

\item{norm_idx_y}{Vector of numeric indices of Y-grid covariates (ordered as 'covariate_y_1','covariate_y_2',...) that should be treated as normally-distributed}

\item{pois_idx_y}{Vector of numeric indices of Y-grid covariates (ordered as 'covariate_y_1','covariate_y_2',...) that should be treated as Poisson-distributed}

\item{binom_idx_y}{Vector of numeric indices of Y-grid covariates (ordered as 'covariate_y_1','covariate_y_2',...) that should be treated as binomial-distributed}

\item{dist_y}{Distribution type for outcome (1=normal, 2=poisson, 3=binomial)}

\item{niter}{Number of MCMC iterations (default: 50000)}

\item{nburnin}{Number of burn-in iterations (default: 30000)}

\item{nchains}{Number of MCMC chains (default: 2)}

\item{thin}{Thinning interval (default: 10)}

\item{seed}{Integer seed for reproducibility. Each chain uses seed+(chain_number-1) (default: NULL)}

\item{sim_metadata}{Optional simulation metadata list}

\item{save_plots}{Logical, whether to save diagnostic plots (default: TRUE)}

\item{output_dir}{Directory for saving outputs (default: NULL)}
}
\value{
List containing MCMC results and parameter estimates
}
\description{
Runs the Atom-Based Regression Model on simulated data
}
